/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import org.cache2k.MutableCacheEntry;
import org.cache2k.impl.BaseCache;
import org.cache2k.impl.CacheInternalError;
import org.cache2k.impl.ExceptionWrapper;
import org.cache2k.storage.StorageEntry;

public class Entry<E extends Entry, K, T>
implements MutableCacheEntry<K, T>,
StorageEntry {
    static final int FETCHED_STATE = 16;
    static final int REFRESH_STATE = 17;
    static final int REPUT_STATE = 19;
    static final int FETCH_IN_PROGRESS_VALID = 20;
    static final int LOADED_NON_VALID_AND_PUT = 9;
    static final int FETCH_ABORT = 8;
    static final int FETCH_IN_PROGRESS_NON_VALID = 7;
    static final int LOADED_NON_VALID_AND_FETCH = 6;
    static final int LOADED_NON_VALID = 5;
    static final int EXPIRED_STATE = 4;
    static final int FETCH_NEXT_TIME_STATE = 3;
    private static final int REMOVED_STATE = 2;
    private static final int FETCH_IN_PROGRESS_VIRGIN = 1;
    static final int VIRGIN_STATE = 0;
    static final int EXPIRY_TIME_MIN = 32;
    private static final StaleMarker STALE_MARKER_KEY = new StaleMarker();
    static final InitialValueInEntryNeverReturned INITIAL_VALUE = new InitialValueInEntryNeverReturned();
    public BaseCache.MyTimerTask task;
    public long fetchedTime;
    public volatile long nextRefreshTime;
    public K key;
    public volatile T value = INITIAL_VALUE;
    public int hashCode;
    public Entry<E, K, T> another;
    public E next;
    public E prev;

    public void setLastModification(long t) {
        this.fetchedTime = t << 1;
    }

    public boolean isDirty() {
        return (this.fetchedTime & 1L) == 0L;
    }

    public void setLastModificationFromStorage(long t) {
        this.fetchedTime = t << 1 | 1L;
    }

    public void resetDirty() {
        this.fetchedTime |= 1L;
    }

    public final void removedFromList() {
        this.next = null;
    }

    public boolean isRemovedFromReplacementList() {
        return this.isStale() || this.next == null;
    }

    public E shortCircuit() {
        this.prev = this;
        this.next = this.prev;
        return this.prev;
    }

    public final boolean isVirgin() {
        return this.nextRefreshTime == 0L || this.nextRefreshTime == 1L;
    }

    public final boolean isFetchNextTimeState() {
        return this.nextRefreshTime == 3L;
    }

    public final boolean isDataValidState() {
        return this.nextRefreshTime >= 16L || this.nextRefreshTime < 0L;
    }

    public void startFetch() {
        this.nextRefreshTime = this.isVirgin() ? 1L : 7L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishFetch(long _nextRefreshTime) {
        Entry entry = this;
        synchronized (entry) {
            this.nextRefreshTime = _nextRefreshTime;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureFetchAbort(boolean _finished) {
        if (_finished) {
            return;
        }
        if (this.isFetchInProgress()) {
            Entry entry = this;
            synchronized (entry) {
                if (this.isFetchInProgress()) {
                    this.nextRefreshTime = 8L;
                    this.notifyAll();
                }
            }
        }
    }

    public boolean isPinned() {
        return this.isFetchInProgress();
    }

    public boolean isFetchInProgress() {
        return this.nextRefreshTime == 17L || this.nextRefreshTime == 6L || this.nextRefreshTime == 1L || this.nextRefreshTime == 9L || this.nextRefreshTime == 7L || this.nextRefreshTime == 20L;
    }

    public void waitForFetch() {
        if (!this.isFetchInProgress()) {
            return;
        }
        try {
            do {
                this.wait();
            } while (this.isFetchInProgress());
        }
        catch (InterruptedException e) {
            throw new CacheInternalError();
        }
    }

    public final boolean hasFreshData() {
        if (this.nextRefreshTime >= 16L) {
            return true;
        }
        if (this.needsTimeCheck()) {
            long now = System.currentTimeMillis();
            return now < -this.nextRefreshTime;
        }
        return false;
    }

    public final boolean hasFreshData(long now) {
        if (this.nextRefreshTime >= 16L) {
            return true;
        }
        if (this.needsTimeCheck()) {
            return now < -this.nextRefreshTime;
        }
        return false;
    }

    public final boolean hasFreshData(long now, long _nextRefreshTime) {
        if (_nextRefreshTime >= 16L) {
            return true;
        }
        if (_nextRefreshTime < 0L) {
            return now < -_nextRefreshTime;
        }
        return false;
    }

    public boolean isLoadedNonValid() {
        return this.nextRefreshTime == 5L;
    }

    public void setLoadedNonValidAndFetch() {
        this.nextRefreshTime = 6L;
    }

    public boolean isLoadedNonValidAndFetch() {
        return this.nextRefreshTime == 6L;
    }

    public void setExpiredState() {
        this.nextRefreshTime = 4L;
    }

    public boolean isExpiredState() {
        return this.nextRefreshTime == 4L;
    }

    public void setRemovedState() {
        this.nextRefreshTime = 2L;
    }

    public boolean isRemovedState() {
        return this.nextRefreshTime == 2L;
    }

    public void setGettingRefresh() {
        this.nextRefreshTime = 17L;
    }

    public boolean isGettingRefresh() {
        return this.nextRefreshTime == 17L;
    }

    public boolean isBeeingReput() {
        return this.nextRefreshTime == 19L;
    }

    public boolean needsTimeCheck() {
        return this.nextRefreshTime < 0L;
    }

    public boolean isStale() {
        return STALE_MARKER_KEY == this.key;
    }

    public void setStale() {
        this.key = STALE_MARKER_KEY;
    }

    public boolean hasException() {
        return this.value instanceof ExceptionWrapper;
    }

    public Throwable getException() {
        if (this.value instanceof ExceptionWrapper) {
            return ((ExceptionWrapper)this.value).getException();
        }
        return null;
    }

    public void setException(Throwable exception) {
        this.value = new ExceptionWrapper(exception);
    }

    public T getValue() {
        if (this.value instanceof ExceptionWrapper) {
            return null;
        }
        return this.value;
    }

    public void setValue(T v) {
        this.value = v;
    }

    public K getKey() {
        return this.key;
    }

    public long getLastModification() {
        return this.fetchedTime >> 1;
    }

    @Override
    public long getValueExpiryTime() {
        if (this.nextRefreshTime < 0L) {
            return -this.nextRefreshTime;
        }
        if (this.nextRefreshTime > 32L) {
            return this.nextRefreshTime;
        }
        return 0L;
    }

    @Override
    public Object getValueOrException() {
        return this.value;
    }

    @Override
    public long getCreatedOrUpdated() {
        return this.getLastModification();
    }

    @Override
    public long getEntryExpiryTime() {
        return 0L;
    }

    public String toString() {
        return "Entry{createdOrUpdate=" + this.getCreatedOrUpdated() + ", nextRefreshTime=" + this.nextRefreshTime + ", valueExpiryTime=" + this.getValueExpiryTime() + ", entryExpiryTime=" + this.getEntryExpiryTime() + ", key=" + this.key + ", mHC=" + this.hashCode + ", value=" + this.value + ", dirty=" + this.isDirty() + '}';
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    static {
        Entry e = new Entry();
        e.nextRefreshTime = 16L;
        e.setGettingRefresh();
        e = new Entry();
        e.setLoadedNonValidAndFetch();
        e.setExpiredState();
    }

    static class StaleMarker {
        StaleMarker() {
        }

        public boolean equals(Object o) {
            return false;
        }
    }

    static class InitialValueInEntryNeverReturned {
        InitialValueInEntryNeverReturned() {
        }
    }
}

