/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowLock;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorProtocol;

public interface HTableInterface
extends Closeable {
    public byte[] getTableName();

    public Configuration getConfiguration();

    public HTableDescriptor getTableDescriptor() throws IOException;

    public boolean exists(Get var1) throws IOException;

    public void batch(List<? extends Row> var1, Object[] var2) throws IOException, InterruptedException;

    public Object[] batch(List<? extends Row> var1) throws IOException, InterruptedException;

    public Result get(Get var1) throws IOException;

    public Result[] get(List<Get> var1) throws IOException;

    public Result getRowOrBefore(byte[] var1, byte[] var2) throws IOException;

    public ResultScanner getScanner(Scan var1) throws IOException;

    public ResultScanner getScanner(byte[] var1) throws IOException;

    public ResultScanner getScanner(byte[] var1, byte[] var2) throws IOException;

    public void put(Put var1) throws IOException;

    public void put(List<Put> var1) throws IOException;

    public boolean checkAndPut(byte[] var1, byte[] var2, byte[] var3, byte[] var4, Put var5) throws IOException;

    public void delete(Delete var1) throws IOException;

    public void delete(List<Delete> var1) throws IOException;

    public boolean checkAndDelete(byte[] var1, byte[] var2, byte[] var3, byte[] var4, Delete var5) throws IOException;

    public void mutateRow(RowMutations var1) throws IOException;

    public Result append(Append var1) throws IOException;

    public Result increment(Increment var1) throws IOException;

    public long incrementColumnValue(byte[] var1, byte[] var2, byte[] var3, long var4) throws IOException;

    public long incrementColumnValue(byte[] var1, byte[] var2, byte[] var3, long var4, boolean var6) throws IOException;

    public boolean isAutoFlush();

    public void flushCommits() throws IOException;

    @Override
    public void close() throws IOException;

    public RowLock lockRow(byte[] var1) throws IOException;

    public void unlockRow(RowLock var1) throws IOException;

    public <T extends CoprocessorProtocol> T coprocessorProxy(Class<T> var1, byte[] var2);

    public <T extends CoprocessorProtocol, R> Map<byte[], R> coprocessorExec(Class<T> var1, byte[] var2, byte[] var3, Batch.Call<T, R> var4) throws IOException, Throwable;

    public <T extends CoprocessorProtocol, R> void coprocessorExec(Class<T> var1, byte[] var2, byte[] var3, Batch.Call<T, R> var4, Batch.Callback<R> var5) throws IOException, Throwable;

    public void setAutoFlush(boolean var1);

    public void setAutoFlush(boolean var1, boolean var2);

    public long getWriteBufferSize();

    public void setWriteBufferSize(long var1) throws IOException;
}

