/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.hbase.Server;

public abstract class BulkAssigner {
    protected final Server server;

    public BulkAssigner(Server server) {
        this.server = server;
    }

    protected String getThreadNamePrefix() {
        return this.server.getServerName() + "-" + this.getClass().getName();
    }

    protected Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                BulkAssigner.this.server.abort("Uncaught exception in " + t.getName(), e);
            }
        };
    }

    protected int getThreadCount() {
        return this.server.getConfiguration().getInt("hbase.bulk.assignment.threadpool.size", 20);
    }

    protected long getTimeoutOnRIT() {
        return this.server.getConfiguration().getLong("hbase.bulk.assignment.waiton.empty.rit", 300000L);
    }

    protected abstract void populatePool(ExecutorService var1) throws IOException;

    public boolean bulkAssign() throws InterruptedException, IOException {
        return this.bulkAssign(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bulkAssign(boolean sync) throws InterruptedException, IOException {
        boolean result = false;
        ThreadFactoryBuilder builder = new ThreadFactoryBuilder();
        builder.setDaemon(true);
        builder.setNameFormat(this.getThreadNamePrefix() + "-%1$d");
        builder.setUncaughtExceptionHandler(this.getUncaughtExceptionHandler());
        int threadCount = this.getThreadCount();
        ExecutorService pool = Executors.newFixedThreadPool(threadCount, builder.build());
        try {
            this.populatePool(pool);
            if (sync) {
                result = this.waitUntilDone(this.getTimeoutOnRIT());
            }
        }
        finally {
            pool.shutdown();
        }
        return result;
    }

    protected abstract boolean waitUntilDone(long var1) throws InterruptedException;
}

