/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;

public class DebugPrint {
    private static final AtomicBoolean enabled = new AtomicBoolean(false);
    private static final Object sync = new Object();
    public static StringBuilder out = new StringBuilder();

    public static void enable() {
        enabled.set(true);
    }

    public static void disable() {
        enabled.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = sync;
        synchronized (object) {
            DebugPrint.enable();
            out = new StringBuilder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpToFile(String file) throws IOException {
        FileWriter f = new FileWriter(file);
        Object object = sync;
        synchronized (object) {
            f.write(out.toString());
        }
        f.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void println(String m) {
        if (!enabled.get()) {
            System.out.println(m);
            return;
        }
        Object object = sync;
        synchronized (object) {
            String threadName = Thread.currentThread().getName();
            out.append("<");
            out.append(threadName);
            out.append("> ");
            out.append(m);
            out.append("\n");
        }
    }
}

