/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.StoreFile;

public class CompactSelection {
    private static final long serialVersionUID = 1L;
    static final Log LOG = LogFactory.getLog(CompactSelection.class);
    List<StoreFile> filesToCompact = new ArrayList<StoreFile>();
    static long numOutstandingOffPeakCompactions = 0L;
    private static final Object compactionCountLock = new Object();
    Configuration conf;
    boolean isOffPeakCompaction = false;
    private double compactRatio;
    private double compactRatioOffPeak;
    private int offPeakStartHour = -1;
    private int offPeakEndHour = -1;

    public CompactSelection(Configuration conf, List<StoreFile> filesToCompact) {
        this.filesToCompact = filesToCompact;
        this.conf = conf;
        this.compactRatio = conf.getFloat("hbase.hstore.compaction.ratio", 1.2f);
        this.compactRatioOffPeak = conf.getFloat("hbase.hstore.compaction.ratio.offpeak", 5.0f);
        this.offPeakStartHour = conf.getInt("hbase.offpeak.start.hour", -1);
        this.offPeakEndHour = conf.getInt("hbase.offpeak.end.hour", -1);
        if (!this.isValidHour(this.offPeakStartHour) || !this.isValidHour(this.offPeakEndHour)) {
            if (this.offPeakStartHour != -1 || this.offPeakEndHour != -1) {
                LOG.warn((Object)("Invalid start/end hour for peak hour : start = " + this.offPeakStartHour + " end = " + this.offPeakEndHour + ". Valid numbers are [0-23]"));
            }
            this.offPeakEndHour = -1;
            this.offPeakStartHour = -1;
        }
    }

    public CompactSelection selectExpiredStoreFilesToCompact(long maxExpiredTimeStamp) {
        if (this.filesToCompact == null || this.filesToCompact.size() == 0) {
            return null;
        }
        ArrayList<StoreFile> expiredStoreFiles = null;
        boolean hasExpiredStoreFiles = false;
        CompactSelection expiredSFSelection = null;
        for (StoreFile storeFile : this.filesToCompact) {
            if (storeFile.getReader().getMaxTimestamp() >= maxExpiredTimeStamp) continue;
            LOG.info((Object)("Deleting the expired store file by compaction: " + storeFile.getPath() + " whose maxTimeStamp is " + storeFile.getReader().getMaxTimestamp() + " while the max expired timestamp is " + maxExpiredTimeStamp));
            if (!hasExpiredStoreFiles) {
                expiredStoreFiles = new ArrayList<StoreFile>();
                hasExpiredStoreFiles = true;
            }
            expiredStoreFiles.add(storeFile);
        }
        if (hasExpiredStoreFiles) {
            expiredSFSelection = new CompactSelection(this.conf, expiredStoreFiles);
        }
        return expiredSFSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getCompactSelectionRatio() {
        double r = this.compactRatio;
        Object object = compactionCountLock;
        synchronized (object) {
            if (this.isOffPeakHour() && numOutstandingOffPeakCompactions == 0L) {
                r = this.compactRatioOffPeak;
                ++numOutstandingOffPeakCompactions;
                this.isOffPeakCompaction = true;
            }
        }
        if (this.isOffPeakCompaction) {
            LOG.info((Object)("Running an off-peak compaction, selection ratio = " + this.compactRatioOffPeak + ", numOutstandingOffPeakCompactions is now " + numOutstandingOffPeakCompactions));
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRequest() {
        if (this.isOffPeakCompaction) {
            Object object = compactionCountLock;
            synchronized (object) {
                this.isOffPeakCompaction = false;
            }
            LOG.info((Object)("Compaction done, numOutstandingOffPeakCompactions is now " + --numOutstandingOffPeakCompactions));
        }
    }

    public List<StoreFile> getFilesToCompact() {
        return this.filesToCompact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emptyFileList() {
        this.filesToCompact.clear();
        if (this.isOffPeakCompaction) {
            Object object = compactionCountLock;
            synchronized (object) {
                this.isOffPeakCompaction = false;
            }
            LOG.info((Object)("Nothing to compact, numOutstandingOffPeakCompactions is now " + --numOutstandingOffPeakCompactions));
        }
    }

    public boolean isOffPeakCompaction() {
        return this.isOffPeakCompaction;
    }

    private boolean isOffPeakHour() {
        int currentHour = new GregorianCalendar().get(11);
        if (this.offPeakStartHour == this.offPeakEndHour) {
            return false;
        }
        if (this.offPeakStartHour < this.offPeakEndHour) {
            return currentHour >= this.offPeakStartHour && currentHour < this.offPeakEndHour;
        }
        return currentHour >= this.offPeakStartHour || currentHour < this.offPeakEndHour;
    }

    public CompactSelection subList(int start, int end) {
        throw new UnsupportedOperationException();
    }

    public CompactSelection getSubList(int start, int end) {
        this.filesToCompact = this.filesToCompact.subList(start, end);
        return this;
    }

    public void clearSubList(int start, int end) {
        this.filesToCompact.subList(start, end).clear();
    }

    private boolean isValidHour(int hour) {
        return hour >= 0 && hour <= 23;
    }
}

