/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.StorageClusterStatusResource;
import org.apache.hadoop.hbase.rest.TableResource;
import org.apache.hadoop.hbase.rest.VersionResource;
import org.apache.hadoop.hbase.rest.model.TableListModel;
import org.apache.hadoop.hbase.rest.model.TableModel;

@Path(value="/")
public class RootResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(RootResource.class);
    static CacheControl cacheControl = new CacheControl();

    private final TableListModel getTableList() throws IOException {
        String[] tableNames;
        TableListModel tableList = new TableListModel();
        for (String name : tableNames = this.servlet.getAdmin().getTableNames()) {
            tableList.add(new TableModel(name));
        }
        return tableList;
    }

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            Response.ResponseBuilder response = Response.ok((Object)this.getTableList());
            response.cacheControl(cacheControl);
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return response.build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            return Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("text/plain").entity((Object)"Unavailable\r\n").build();
        }
    }

    @Path(value="status/cluster")
    public StorageClusterStatusResource getClusterStatusResource() throws IOException {
        return new StorageClusterStatusResource();
    }

    @Path(value="version")
    public VersionResource getVersionResource() throws IOException {
        return new VersionResource();
    }

    @Path(value="{table}")
    public TableResource getTableResource(@PathParam(value="table") String table) throws IOException {
        return new TableResource(table);
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

