/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.thrift;

import com.netflix.astyanax.AstyanaxConfiguration;
import com.netflix.astyanax.Clock;
import com.netflix.astyanax.ColumnMutation;
import com.netflix.astyanax.Execution;
import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.clock.ConstantClock;
import com.netflix.astyanax.model.ConsistencyLevel;
import com.netflix.astyanax.retry.RetryPolicy;
import com.netflix.astyanax.serializers.BooleanSerializer;
import com.netflix.astyanax.serializers.ByteBufferSerializer;
import com.netflix.astyanax.serializers.ByteSerializer;
import com.netflix.astyanax.serializers.BytesArraySerializer;
import com.netflix.astyanax.serializers.DateSerializer;
import com.netflix.astyanax.serializers.DoubleSerializer;
import com.netflix.astyanax.serializers.FloatSerializer;
import com.netflix.astyanax.serializers.IntegerSerializer;
import com.netflix.astyanax.serializers.LongSerializer;
import com.netflix.astyanax.serializers.ShortSerializer;
import com.netflix.astyanax.serializers.StringSerializer;
import com.netflix.astyanax.serializers.UUIDSerializer;
import com.netflix.astyanax.thrift.ThriftUtils;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;

public abstract class AbstractThriftColumnMutationImpl
implements ColumnMutation {
    protected final ByteBuffer key;
    protected final ByteBuffer column;
    protected Clock clock;
    protected RetryPolicy retry;
    protected ConsistencyLevel writeConsistencyLevel;

    public AbstractThriftColumnMutationImpl(ByteBuffer key, ByteBuffer column, AstyanaxConfiguration config) {
        this.key = key;
        this.column = column;
        this.clock = config.getClock();
        this.retry = config.getRetryPolicy().duplicate();
        this.writeConsistencyLevel = config.getDefaultWriteConsistencyLevel();
    }

    public ColumnMutation withRetryPolicy(RetryPolicy retry) {
        this.retry = retry;
        return this;
    }

    public ColumnMutation setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.writeConsistencyLevel = consistencyLevel;
        return this;
    }

    public ColumnMutation withTimestamp(long timestamp) {
        this.clock = new ConstantClock(timestamp);
        return this;
    }

    public Execution<Void> putValue(String value, Integer ttl) {
        return this.insertValue(StringSerializer.get().toByteBuffer(value), ttl);
    }

    public Execution<Void> putValue(byte[] value, Integer ttl) {
        return this.insertValue(BytesArraySerializer.get().toByteBuffer(value), ttl);
    }

    public Execution<Void> putValue(byte value, Integer ttl) {
        return this.insertValue(ByteSerializer.get().toByteBuffer(Byte.valueOf(value)), ttl);
    }

    public Execution<Void> putValue(short value, Integer ttl) {
        return this.insertValue(ShortSerializer.get().toByteBuffer(Short.valueOf(value)), ttl);
    }

    public Execution<Void> putValue(int value, Integer ttl) {
        return this.insertValue(IntegerSerializer.get().toByteBuffer(Integer.valueOf(value)), ttl);
    }

    public Execution<Void> putValue(long value, Integer ttl) {
        return this.insertValue(LongSerializer.get().toByteBuffer(Long.valueOf(value)), ttl);
    }

    public Execution<Void> putValue(boolean value, Integer ttl) {
        return this.insertValue(BooleanSerializer.get().toByteBuffer(Boolean.valueOf(value)), ttl);
    }

    public Execution<Void> putValue(ByteBuffer value, Integer ttl) {
        return this.insertValue(ByteBufferSerializer.get().toByteBuffer(value), ttl);
    }

    public Execution<Void> putValue(Date value, Integer ttl) {
        return this.insertValue(DateSerializer.get().toByteBuffer(value), ttl);
    }

    public Execution<Void> putValue(float value, Integer ttl) {
        return this.insertValue(FloatSerializer.get().toByteBuffer(Float.valueOf(value)), ttl);
    }

    public Execution<Void> putValue(double value, Integer ttl) {
        return this.insertValue(DoubleSerializer.get().toByteBuffer(Double.valueOf(value)), ttl);
    }

    public Execution<Void> putValue(UUID value, Integer ttl) {
        return this.insertValue(UUIDSerializer.get().toByteBuffer(value), ttl);
    }

    public <T> Execution<Void> putValue(T value, Serializer<T> serializer, Integer ttl) {
        return this.insertValue(serializer.toByteBuffer(value), ttl);
    }

    public Execution<Void> putEmptyColumn(Integer ttl) {
        return this.insertValue(ThriftUtils.EMPTY_BYTE_BUFFER, ttl);
    }

    protected abstract Execution<Void> insertValue(ByteBuffer var1, Integer var2);
}

