/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.diskstorage.configuration;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.thinkaurelius.titan.core.util.ReflectiveConfigOptionLoader;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import java.util.Map;

public class ConfigNamespace
extends ConfigElement {
    private final boolean isUmbrella;
    private final Map<String, ConfigElement> children = Maps.newHashMap();

    public ConfigNamespace(ConfigNamespace parent, String name, String description, boolean isUmbrella) {
        super(parent, name, description);
        this.isUmbrella = isUmbrella;
    }

    public ConfigNamespace(ConfigNamespace parent, String name, String description) {
        this(parent, name, description, false);
    }

    public boolean isUmbrella() {
        return this.isUmbrella;
    }

    public boolean hasUmbrella() {
        if (this.isUmbrella()) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        return this.getNamespace().hasUmbrella();
    }

    @Override
    public boolean isOption() {
        return false;
    }

    void registerChild(ConfigElement element) {
        Preconditions.checkNotNull((Object)element);
        Preconditions.checkArgument((element.getNamespace() == this ? 1 : 0) != 0, (Object)"Configuration element registered with wrong namespace");
        Preconditions.checkArgument((!this.children.containsKey(element.getName()) ? 1 : 0) != 0, (String)"A configuration element with the same name has already been added to this namespace: %s", (Object[])new Object[]{element.getName()});
        this.children.put(element.getName(), element);
    }

    public Iterable<ConfigElement> getChildren() {
        return this.children.values();
    }

    public ConfigElement getChild(String name) {
        ConfigElement child = this.children.get(name);
        if (null == child) {
            ReflectiveConfigOptionLoader.INSTANCE.loadStandard(this.getClass());
            child = this.children.get(name);
            if (null == child) {
                ReflectiveConfigOptionLoader.INSTANCE.loadAll(this.getClass());
                child = this.children.get(name);
            }
        }
        return child;
    }
}

