/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;

public class LinkedMapWritable
extends MapWritable {
    private Map<Writable, Writable> instance = new LinkedHashMap<Writable, Writable>();

    public LinkedMapWritable() {
        this.addToMap(LinkedMapWritable.class);
    }

    public LinkedMapWritable(MapWritable other) {
        this();
        this.copy((Writable)other);
    }

    public void clear() {
        this.instance.clear();
    }

    public boolean containsKey(Object key) {
        return this.instance.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.instance.containsValue(value);
    }

    public Set<Map.Entry<Writable, Writable>> entrySet() {
        return this.instance.entrySet();
    }

    public Writable get(Object key) {
        return this.instance.get(key);
    }

    public boolean isEmpty() {
        return this.instance.isEmpty();
    }

    public Set<Writable> keySet() {
        return this.instance.keySet();
    }

    public Writable put(Writable key, Writable value) {
        this.addToMap(key.getClass());
        this.addToMap(value.getClass());
        return this.instance.put(key, value);
    }

    public void putAll(Map<? extends Writable, ? extends Writable> t) {
        for (Map.Entry<? extends Writable, ? extends Writable> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public Writable remove(Object key) {
        return this.instance.remove(key);
    }

    public int size() {
        return this.instance.size();
    }

    public Collection<Writable> values() {
        return this.instance.values();
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.instance.size());
        for (Map.Entry<Writable, Writable> e : this.instance.entrySet()) {
            out.writeByte(this.getId(e.getKey().getClass()));
            e.getKey().write(out);
            out.writeByte(this.getId(e.getValue().getClass()));
            e.getValue().write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.instance.clear();
        int entries = in.readInt();
        for (int i = 0; i < entries; ++i) {
            Writable key = (Writable)ReflectionUtils.newInstance((Class)this.getClass(in.readByte()), (Configuration)this.getConf());
            key.readFields(in);
            Writable value = (Writable)ReflectionUtils.newInstance((Class)this.getClass(in.readByte()), (Configuration)this.getConf());
            value.readFields(in);
            this.instance.put(key, value);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<Writable, Writable> e : this.entrySet()) {
                Writable key = e.getKey();
                Writable value = e.getValue();
                if (!(value == null ? m.get(key) != null || !m.containsKey(key) : !value.equals(m.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<Writable, Writable>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public String toString() {
        Iterator<Map.Entry<Writable, Writable>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Map.Entry<Writable, Writable> e = i.next();
            Writable key = e.getKey();
            Writable value = e.getValue();
            sb.append((Object)(key == this ? "(this Map)" : key));
            sb.append('=');
            if (value instanceof ArrayWritable) {
                sb.append(Arrays.toString(((ArrayWritable)value).get()));
            } else {
                sb.append((Object)(value == this ? "(this Map)" : value));
            }
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }
}

