/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common;

import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.hppc.ObjectObjectAssociativeContainer;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;

public class ContextHolder {
    private ObjectObjectOpenHashMap<Object, Object> context;

    public final synchronized <V> V putInContext(Object key, Object value) {
        if (this.context == null) {
            this.context = new ObjectObjectOpenHashMap(2);
        }
        return (V)this.context.put(key, value);
    }

    public final synchronized void putAllInContext(ObjectObjectAssociativeContainer<Object, Object> map) {
        if (map == null) {
            return;
        }
        if (this.context == null) {
            this.context = new ObjectObjectOpenHashMap<Object, Object>(map);
        } else {
            this.context.putAll(map);
        }
    }

    public final synchronized <V> V getFromContext(Object key) {
        return (V)(this.context != null ? this.context.get(key) : null);
    }

    public final synchronized <V> V getFromContext(Object key, V defaultValue) {
        V value = this.getFromContext(key);
        return value == null ? defaultValue : value;
    }

    public final synchronized boolean hasInContext(Object key) {
        return this.context != null && this.context.containsKey(key);
    }

    public final synchronized int contextSize() {
        return this.context != null ? this.context.size() : 0;
    }

    public final synchronized boolean isContextEmpty() {
        return this.context == null || this.context.isEmpty();
    }

    public synchronized ImmutableOpenMap<Object, Object> getContext() {
        return this.context != null ? ImmutableOpenMap.copyOf(this.context) : ImmutableOpenMap.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyContextFrom(ContextHolder other) {
        ContextHolder contextHolder = other;
        synchronized (contextHolder) {
            if (other.context == null) {
                return;
            }
            if (this.context == null) {
                this.context = new ObjectObjectOpenHashMap<Object, Object>(other.context);
            } else {
                this.context.putAll((ObjectObjectAssociativeContainer<Object, Object>)other.context);
            }
        }
    }
}

