/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.query;

import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.cache.RemovalListener;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.cache.query.QueryCacheStats;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.cache.query.IndicesQueryCache;

public class ShardQueryCache
extends AbstractIndexShardComponent
implements RemovalListener<IndicesQueryCache.Key, BytesReference> {
    final CounterMetric evictionsMetric = new CounterMetric();
    final CounterMetric totalMetric = new CounterMetric();
    final CounterMetric hitCount = new CounterMetric();
    final CounterMetric missCount = new CounterMetric();

    @Inject
    public ShardQueryCache(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
    }

    public QueryCacheStats stats() {
        return new QueryCacheStats(this.totalMetric.count(), this.evictionsMetric.count(), this.hitCount.count(), this.missCount.count());
    }

    public void onHit() {
        this.hitCount.inc();
    }

    public void onMiss() {
        this.missCount.inc();
    }

    public void onCached(IndicesQueryCache.Key key, BytesReference value) {
        this.totalMetric.inc(key.ramBytesUsed() + (long)value.length());
    }

    @Override
    public void onRemoval(RemovalNotification<IndicesQueryCache.Key, BytesReference> removalNotification) {
        if (removalNotification.wasEvicted()) {
            this.evictionsMetric.inc();
        }
        long dec = 0L;
        if (removalNotification.getKey() != null) {
            dec += removalNotification.getKey().ramBytesUsed();
        }
        if (removalNotification.getValue() != null) {
            dec += (long)removalNotification.getValue().length();
        }
        this.totalMetric.dec(dec);
    }
}

