/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.GeoPointValues;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicGeoPointFieldData;

public abstract class GeoPointDoubleArrayAtomicFieldData
extends AbstractAtomicGeoPointFieldData {
    @Override
    public void close() {
    }

    public static class Single
    extends GeoPointDoubleArrayAtomicFieldData {
        private final DoubleArray lon;
        private final DoubleArray lat;
        private final FixedBitSet set;

        public Single(DoubleArray lon, DoubleArray lat, FixedBitSet set) {
            this.lon = lon;
            this.lat = lat;
            this.set = set;
        }

        public long ramBytesUsed() {
            return 4L + this.lon.ramBytesUsed() + this.lat.ramBytesUsed() + (this.set == null ? 0L : this.set.ramBytesUsed());
        }

        @Override
        public MultiGeoPointValues getGeoPointValues() {
            final GeoPoint point = new GeoPoint();
            GeoPointValues values = new GeoPointValues(){

                @Override
                public GeoPoint get(int docID) {
                    point.reset(Single.this.lat.get(docID), Single.this.lon.get(docID));
                    return point;
                }
            };
            return FieldData.singleton(values, (Bits)this.set);
        }
    }

    static class WithOrdinals
    extends GeoPointDoubleArrayAtomicFieldData {
        private final DoubleArray lon;
        private final DoubleArray lat;
        private final Ordinals ordinals;
        private final int maxDoc;

        public WithOrdinals(DoubleArray lon, DoubleArray lat, Ordinals ordinals, int maxDoc) {
            this.lon = lon;
            this.lat = lat;
            this.ordinals = ordinals;
            this.maxDoc = maxDoc;
        }

        public long ramBytesUsed() {
            return 4L + this.lon.ramBytesUsed() + this.lat.ramBytesUsed();
        }

        @Override
        public MultiGeoPointValues getGeoPointValues() {
            final RandomAccessOrds ords = this.ordinals.ordinals();
            final SortedDocValues singleOrds = DocValues.unwrapSingleton((SortedSetDocValues)ords);
            if (singleOrds != null) {
                final GeoPoint point = new GeoPoint();
                GeoPointValues values = new GeoPointValues(){

                    @Override
                    public GeoPoint get(int docID) {
                        int ord = singleOrds.getOrd(docID);
                        if (ord >= 0) {
                            point.reset(WithOrdinals.this.lat.get(ord), WithOrdinals.this.lon.get(ord));
                        }
                        return point;
                    }
                };
                return FieldData.singleton(values, DocValues.docsWithValue((SortedDocValues)singleOrds, (int)this.maxDoc));
            }
            final GeoPoint point = new GeoPoint();
            return new MultiGeoPointValues(){

                @Override
                public GeoPoint valueAt(int index) {
                    long ord = ords.ordAt(index);
                    point.reset(WithOrdinals.this.lat.get(ord), WithOrdinals.this.lon.get(ord));
                    return point;
                }

                @Override
                public void setDocument(int docId) {
                    ords.setDocument(docId);
                }

                @Override
                public int count() {
                    return ords.cardinality();
                }
            };
        }
    }
}

