/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.percolator.stats;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.percolator.stats.PercolateStats;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class ShardPercolateService
extends AbstractIndexShardComponent {
    private final MeanMetric percolateMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();
    private final CounterMetric numberOfQueries = new CounterMetric();

    @Inject
    public ShardPercolateService(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
    }

    public void prePercolate() {
        this.currentMetric.inc();
    }

    public void postPercolate(long tookInNanos) {
        this.currentMetric.dec();
        this.percolateMetric.inc(tookInNanos);
    }

    public void addedQuery(BytesRef id, Query previousQuery, Query newQuery) {
        this.numberOfQueries.inc();
    }

    public void removedQuery(BytesRef id, Query query) {
        this.numberOfQueries.dec();
    }

    public PercolateStats stats() {
        return new PercolateStats(this.percolateMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.percolateMetric.sum()), this.currentMetric.count(), -1L, this.numberOfQueries.count());
    }
}

