/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.query;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.FilterParser;
import org.elasticsearch.index.query.QueryParser;

public class IndicesQueriesRegistry
extends AbstractComponent {
    private ImmutableMap<String, QueryParser> queryParsers;
    private ImmutableMap<String, FilterParser> filterParsers;

    @Inject
    public IndicesQueriesRegistry(Settings settings, Set<QueryParser> injectedQueryParsers, Set<FilterParser> injectedFilterParsers) {
        super(settings);
        HashMap<String, QueryParser> queryParsers = Maps.newHashMap();
        for (QueryParser queryParser : injectedQueryParsers) {
            this.addQueryParser(queryParsers, queryParser);
        }
        this.queryParsers = ImmutableMap.copyOf(queryParsers);
        HashMap<String, FilterParser> filterParsers = Maps.newHashMap();
        for (FilterParser filterParser : injectedFilterParsers) {
            this.addFilterParser(filterParsers, filterParser);
        }
        this.filterParsers = ImmutableMap.copyOf(filterParsers);
    }

    public synchronized void addQueryParser(QueryParser queryParser) {
        HashMap<String, QueryParser> queryParsers = Maps.newHashMap(this.queryParsers);
        this.addQueryParser(queryParsers, queryParser);
        this.queryParsers = ImmutableMap.copyOf(queryParsers);
    }

    public synchronized void addFilterParser(FilterParser filterParser) {
        HashMap<String, FilterParser> filterParsers = Maps.newHashMap(this.filterParsers);
        this.addFilterParser(filterParsers, filterParser);
        this.filterParsers = ImmutableMap.copyOf(filterParsers);
    }

    public ImmutableMap<String, QueryParser> queryParsers() {
        return this.queryParsers;
    }

    public ImmutableMap<String, FilterParser> filterParsers() {
        return this.filterParsers;
    }

    private void addQueryParser(Map<String, QueryParser> queryParsers, QueryParser queryParser) {
        for (String name : queryParser.names()) {
            queryParsers.put(name, queryParser);
        }
    }

    private void addFilterParser(Map<String, FilterParser> filterParsers, FilterParser filterParser) {
        for (String name : filterParser.names()) {
            filterParsers.put(name, filterParser);
        }
    }
}

