/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.lucene.store.RateLimiter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.ByteStreams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.jackson.core.JsonParseException;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.shard.IndexShardException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardRepository;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositorySettings;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.blobstore.BlobStoreSnapshot;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotCreationException;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotShardFailure;

public abstract class BlobStoreRepository
extends AbstractLifecycleComponent<Repository>
implements Repository,
BlobStoreIndexShardRepository.RateLimiterListener {
    private BlobContainer snapshotsBlobContainer;
    protected final String repositoryName;
    private static final String SNAPSHOT_PREFIX = "snapshot-";
    private static final String SNAPSHOTS_FILE = "index";
    private static final String TESTS_FILE = "tests-";
    private static final String METADATA_PREFIX = "metadata-";
    private final BlobStoreIndexShardRepository indexShardRepository;
    private final ToXContent.Params snapshotOnlyFormatParams;
    private final RateLimiter snapshotRateLimiter;
    private final RateLimiter restoreRateLimiter;
    private final CounterMetric snapshotRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric restoreRateLimitingTimeInNanos = new CounterMetric();

    protected BlobStoreRepository(String repositoryName, RepositorySettings repositorySettings, IndexShardRepository indexShardRepository) {
        super(repositorySettings.globalSettings());
        this.repositoryName = repositoryName;
        this.indexShardRepository = (BlobStoreIndexShardRepository)indexShardRepository;
        HashMap<String, String> snpashotOnlyParams = Maps.newHashMap();
        snpashotOnlyParams.put("context_mode", MetaData.CONTEXT_MODE_SNAPSHOT);
        this.snapshotOnlyFormatParams = new ToXContent.MapParams(snpashotOnlyParams);
        this.snapshotRateLimiter = this.getRateLimiter(repositorySettings, "max_snapshot_bytes_per_sec", new ByteSizeValue(20L, ByteSizeUnit.MB));
        this.restoreRateLimiter = this.getRateLimiter(repositorySettings, "max_restore_bytes_per_sec", new ByteSizeValue(20L, ByteSizeUnit.MB));
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        this.snapshotsBlobContainer = this.blobStore().blobContainer(this.basePath());
        this.indexShardRepository.initialize(this.blobStore(), this.basePath(), this.chunkSize(), this.snapshotRateLimiter, this.restoreRateLimiter, this);
    }

    @Override
    protected void doStop() throws ElasticsearchException {
    }

    @Override
    protected void doClose() throws ElasticsearchException {
        try {
            this.blobStore().close();
        }
        catch (Throwable t) {
            this.logger.warn("cannot close blob store", t, new Object[0]);
        }
    }

    protected abstract BlobStore blobStore();

    protected abstract BlobPath basePath();

    protected boolean isCompress() {
        return false;
    }

    protected ByteSizeValue chunkSize() {
        return null;
    }

    @Override
    public void initializeSnapshot(SnapshotId snapshotId, ImmutableList<String> indices, MetaData metaData) {
        try {
            BlobStoreSnapshot blobStoreSnapshot = BlobStoreSnapshot.builder().name(snapshotId.getSnapshot()).indices(indices).startTime(System.currentTimeMillis()).build();
            String snapshotBlobName = this.snapshotBlobName(snapshotId);
            if (this.snapshotsBlobContainer.blobExists(snapshotBlobName)) {
                throw new InvalidSnapshotNameException(snapshotId, "snapshot with such name already exists");
            }
            try (OutputStream output = this.snapshotsBlobContainer.createOutput(snapshotBlobName);){
                this.writeSnapshot(blobStoreSnapshot, output);
            }
            output = this.snapshotsBlobContainer.createOutput(this.metaDataBlobName(snapshotId));
            var7_8 = null;
            try {
                this.writeGlobalMetaData(metaData, output);
            }
            catch (Throwable x2) {
                var7_8 = x2;
                throw x2;
            }
            finally {
                if (output != null) {
                    if (var7_8 != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable x2) {
                            var7_8.addSuppressed(x2);
                        }
                    } else {
                        output.close();
                    }
                }
            }
            for (String index : indices) {
                IndexMetaData indexMetaData = metaData.index(index);
                BlobPath indexPath = this.basePath().add("indices").add(index);
                BlobContainer indexMetaDataBlobContainer = this.blobStore().blobContainer(indexPath);
                OutputStream output = indexMetaDataBlobContainer.createOutput(this.snapshotBlobName(snapshotId));
                Throwable throwable = null;
                try {
                    StreamOutput stream = new OutputStreamStreamOutput(output);
                    if (this.isCompress()) {
                        stream = CompressorFactory.defaultCompressor().streamOutput(stream);
                    }
                    XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON, stream);
                    builder.startObject();
                    IndexMetaData.Builder.toXContent(indexMetaData, builder, ToXContent.EMPTY_PARAMS);
                    builder.endObject();
                    builder.close();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (output == null) continue;
                    if (throwable != null) {
                        try {
                            output.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    output.close();
                }
            }
        }
        catch (IOException ex) {
            throw new SnapshotCreationException(snapshotId, (Throwable)ex);
        }
    }

    @Override
    public void deleteSnapshot(SnapshotId snapshotId) {
        Snapshot snapshot = this.readSnapshot(snapshotId);
        MetaData metaData = null;
        try {
            metaData = this.readSnapshotMetaData(snapshotId, snapshot.indices(), true);
        }
        catch (SnapshotException ex) {
            this.logger.warn("cannot read metadata for snapshot [{}]", ex, snapshotId);
        }
        try {
            String blobName = this.snapshotBlobName(snapshotId);
            this.snapshotsBlobContainer.deleteBlob(blobName);
            this.snapshotsBlobContainer.deleteBlob(this.metaDataBlobName(snapshotId));
            ImmutableCollection snapshotIds = this.snapshots();
            if (snapshotIds.contains(snapshotId)) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (SnapshotId id : snapshotIds) {
                    if (snapshotId.equals(id)) continue;
                    builder.add(id);
                }
                snapshotIds = builder.build();
            }
            this.writeSnapshotList((ImmutableList<SnapshotId>)snapshotIds);
            for (String index : snapshot.indices()) {
                IndexMetaData indexMetaData;
                BlobPath indexPath = this.basePath().add("indices").add(index);
                BlobContainer indexMetaDataBlobContainer = this.blobStore().blobContainer(indexPath);
                try {
                    indexMetaDataBlobContainer.deleteBlob(blobName);
                }
                catch (IOException ex) {
                    this.logger.warn("[{}] failed to delete metadata for index [{}]", ex, snapshotId, index);
                }
                if (metaData == null || (indexMetaData = metaData.index(index)) == null) continue;
                for (int i = 0; i < indexMetaData.getNumberOfShards(); ++i) {
                    ShardId shardId = new ShardId(index, i);
                    try {
                        this.indexShardRepository.delete(snapshotId, shardId);
                        continue;
                    }
                    catch (IndexShardException | SnapshotException ex) {
                        this.logger.warn("[{}] failed to delete shard data for shard [{}]", ex, snapshotId, shardId);
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new RepositoryException(this.repositoryName, "failed to update snapshot in repository", ex);
        }
    }

    @Override
    public Snapshot finalizeSnapshot(SnapshotId snapshotId, String failure, int totalShards, ImmutableList<SnapshotShardFailure> shardFailures) {
        BlobStoreSnapshot snapshot = (BlobStoreSnapshot)this.readSnapshot(snapshotId);
        if (snapshot == null) {
            throw new SnapshotMissingException(snapshotId);
        }
        if (snapshot.state().completed()) {
            throw new SnapshotException(snapshotId, "snapshot is already closed");
        }
        try {
            String blobName = this.snapshotBlobName(snapshotId);
            BlobStoreSnapshot.Builder updatedSnapshot = BlobStoreSnapshot.builder().snapshot(snapshot);
            if (failure == null) {
                if (shardFailures.isEmpty()) {
                    updatedSnapshot.success();
                } else {
                    updatedSnapshot.partial();
                }
                updatedSnapshot.failures(totalShards, shardFailures);
            } else {
                updatedSnapshot.failed(failure);
            }
            updatedSnapshot.endTime(System.currentTimeMillis());
            snapshot = updatedSnapshot.build();
            try (OutputStream output = this.snapshotsBlobContainer.createOutput(blobName);){
                this.writeSnapshot(snapshot, output);
            }
            ImmutableCollection snapshotIds = this.snapshots();
            if (!snapshotIds.contains(snapshotId)) {
                snapshotIds = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)snapshotIds)).add(snapshotId)).build();
            }
            this.writeSnapshotList((ImmutableList<SnapshotId>)snapshotIds);
            return snapshot;
        }
        catch (IOException ex) {
            throw new RepositoryException(this.repositoryName, "failed to update snapshot in repository", ex);
        }
    }

    @Override
    public ImmutableList<SnapshotId> snapshots() {
        try {
            ImmutableMap<String, BlobMetaData> blobs;
            ArrayList<SnapshotId> snapshots = Lists.newArrayList();
            try {
                blobs = this.snapshotsBlobContainer.listBlobsByPrefix(SNAPSHOT_PREFIX);
            }
            catch (UnsupportedOperationException ex) {
                return this.readSnapshotList();
            }
            int prefixLength = SNAPSHOT_PREFIX.length();
            for (BlobMetaData md : blobs.values()) {
                String name = md.name().substring(prefixLength);
                snapshots.add(new SnapshotId(this.repositoryName, name));
            }
            return ImmutableList.copyOf(snapshots);
        }
        catch (IOException ex) {
            throw new RepositoryException(this.repositoryName, "failed to list snapshots in repository", ex);
        }
    }

    @Override
    public MetaData readSnapshotMetaData(SnapshotId snapshotId, ImmutableList<String> indices) {
        return this.readSnapshotMetaData(snapshotId, indices, false);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Snapshot readSnapshot(SnapshotId snapshotId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private MetaData readSnapshotMetaData(SnapshotId snapshotId, ImmutableList<String> indices, boolean ignoreIndexErrors) {
        MetaData metaData;
        try (InputStream blob = this.snapshotsBlobContainer.openInput(this.metaDataBlobName(snapshotId));){
            byte[] data = ByteStreams.toByteArray(blob);
            metaData = this.readMetaData(data);
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            throw new SnapshotMissingException(snapshotId, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SnapshotException(snapshotId, "failed to get snapshots", ex);
        }
        MetaData.Builder metaDataBuilder = MetaData.builder(metaData);
        for (String index : indices) {
            BlobPath indexPath = this.basePath().add("indices").add(index);
            BlobContainer indexMetaDataBlobContainer = this.blobStore().blobContainer(indexPath);
            try {
                InputStream blob = indexMetaDataBlobContainer.openInput(this.snapshotBlobName(snapshotId));
                Throwable throwable = null;
                try {
                    byte[] data = ByteStreams.toByteArray(blob);
                    XContentParser parser = XContentHelper.createParser(data, 0, data.length);
                    Throwable throwable2 = null;
                    try {
                        XContentParser.Token token = parser.nextToken();
                        if (token == XContentParser.Token.START_OBJECT) {
                            IndexMetaData indexMetaData = IndexMetaData.Builder.fromXContent(parser);
                            token = parser.nextToken();
                            if (token == XContentParser.Token.END_OBJECT) {
                                metaDataBuilder.put(indexMetaData, false);
                                continue;
                            }
                        }
                        if (!ignoreIndexErrors) {
                            throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
                        }
                        this.logger.warn("[{}] [{}] unexpected token while reading snapshot metadata [{}]", new Object[]{snapshotId, index, token});
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (parser == null) continue;
                        if (throwable2 != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        parser.close();
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (blob == null) continue;
                    if (throwable != null) {
                        try {
                            blob.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    blob.close();
                }
            }
            catch (IOException ex) {
                if (!ignoreIndexErrors) {
                    throw new SnapshotException(snapshotId, "failed to read metadata", ex);
                }
                this.logger.warn("[{}] [{}] failed to read metadata for index", snapshotId, index, ex);
            }
        }
        return metaDataBuilder.build();
    }

    private RateLimiter getRateLimiter(RepositorySettings repositorySettings, String setting, ByteSizeValue defaultRate) {
        ByteSizeValue maxSnapshotBytesPerSec = repositorySettings.settings().getAsBytesSize(setting, this.componentSettings.getAsBytesSize(setting, defaultRate));
        if (maxSnapshotBytesPerSec.bytes() <= 0L) {
            return null;
        }
        return new RateLimiter.SimpleRateLimiter(maxSnapshotBytesPerSec.mbFrac());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BlobStoreSnapshot readSnapshot(byte[] data) throws IOException {
        try (XContentParser parser = XContentHelper.createParser(data, 0, data.length);){
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT && (token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                parser.nextToken();
                BlobStoreSnapshot snapshot = BlobStoreSnapshot.Builder.fromXContent(parser);
                token = parser.nextToken();
                if (token == XContentParser.Token.END_OBJECT) {
                    BlobStoreSnapshot blobStoreSnapshot = snapshot;
                    return blobStoreSnapshot;
                }
            }
            throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
        }
        catch (JsonParseException ex) {
            throw new ElasticsearchParseException("failed to read snapshot", ex);
        }
    }

    private MetaData readMetaData(byte[] data) throws IOException {
        Throwable throwable = null;
        try (XContentParser parser = XContentHelper.createParser(data, 0, data.length);){
            XContentParser.Token token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT && (token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                parser.nextToken();
                MetaData metaData = MetaData.Builder.fromXContent(parser);
                token = parser.nextToken();
                if (token == XContentParser.Token.END_OBJECT) {
                    MetaData metaData2 = metaData;
                    return metaData2;
                }
            }
            try {
                throw new ElasticsearchParseException("unexpected token  [" + (Object)((Object)token) + "]");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private String snapshotBlobName(SnapshotId snapshotId) {
        return SNAPSHOT_PREFIX + snapshotId.getSnapshot();
    }

    private String metaDataBlobName(SnapshotId snapshotId) {
        return METADATA_PREFIX + snapshotId.getSnapshot();
    }

    private void writeSnapshot(BlobStoreSnapshot snapshot, OutputStream outputStream) throws IOException {
        StreamOutput stream = new OutputStreamStreamOutput(outputStream);
        if (this.isCompress()) {
            stream = CompressorFactory.defaultCompressor().streamOutput(stream);
        }
        XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON, stream);
        builder.startObject();
        BlobStoreSnapshot.Builder.toXContent(snapshot, builder, this.snapshotOnlyFormatParams);
        builder.endObject();
        builder.close();
    }

    private void writeGlobalMetaData(MetaData metaData, OutputStream outputStream) throws IOException {
        StreamOutput stream = new OutputStreamStreamOutput(outputStream);
        if (this.isCompress()) {
            stream = CompressorFactory.defaultCompressor().streamOutput(stream);
        }
        XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON, stream);
        builder.startObject();
        MetaData.Builder.toXContent(metaData, builder, this.snapshotOnlyFormatParams);
        builder.endObject();
        builder.close();
    }

    protected void writeSnapshotList(ImmutableList<SnapshotId> snapshots) throws IOException {
        BytesStreamOutput bStream;
        StreamOutput stream = bStream = new BytesStreamOutput();
        if (this.isCompress()) {
            stream = CompressorFactory.defaultCompressor().streamOutput(stream);
        }
        XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON, stream);
        builder.startObject();
        builder.startArray("snapshots");
        for (SnapshotId snapshot : snapshots) {
            builder.value(snapshot.getSnapshot());
        }
        builder.endArray();
        builder.endObject();
        builder.close();
        BytesReference bRef = bStream.bytes();
        try (OutputStream output = this.snapshotsBlobContainer.createOutput(SNAPSHOTS_FILE);){
            bRef.writeTo(output);
        }
    }

    protected ImmutableList<SnapshotId> readSnapshotList() throws IOException {
        try (InputStream blob = this.snapshotsBlobContainer.openInput(SNAPSHOTS_FILE);){
            byte[] data = ByteStreams.toByteArray(blob);
            ArrayList<SnapshotId> snapshots = new ArrayList<SnapshotId>();
            try (XContentParser parser = XContentHelper.createParser(data, 0, data.length);){
                String currentFieldName;
                if (parser.nextToken() == XContentParser.Token.START_OBJECT && parser.nextToken() == XContentParser.Token.FIELD_NAME && "snapshots".equals(currentFieldName = parser.currentName()) && parser.nextToken() == XContentParser.Token.START_ARRAY) {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        snapshots.add(new SnapshotId(this.repositoryName, parser.text()));
                    }
                }
            }
            ImmutableList<SnapshotId> immutableList = ImmutableList.copyOf(snapshots);
            return immutableList;
        }
    }

    @Override
    public void onRestorePause(long nanos) {
        this.restoreRateLimitingTimeInNanos.inc(nanos);
    }

    @Override
    public void onSnapshotPause(long nanos) {
        this.snapshotRateLimitingTimeInNanos.inc(nanos);
    }

    @Override
    public long snapshotThrottleTimeInNanos() {
        return this.snapshotRateLimitingTimeInNanos.count();
    }

    @Override
    public long restoreThrottleTimeInNanos() {
        return this.restoreRateLimitingTimeInNanos.count();
    }

    @Override
    public String startVerification() {
        try {
            String seed = Strings.randomBase64UUID();
            byte[] testBytes = Strings.toUTF8Bytes(seed);
            try (OutputStream outputStream = this.snapshotsBlobContainer.createOutput(BlobStoreRepository.testBlobPrefix(seed) + "-master");){
                outputStream.write(testBytes);
            }
            return seed;
        }
        catch (IOException exp) {
            throw new RepositoryVerificationException(this.repositoryName, "path " + this.basePath() + " is not accessible on master node", exp);
        }
    }

    @Override
    public void endVerification(String seed) {
        try {
            this.snapshotsBlobContainer.deleteBlobsByPrefix(BlobStoreRepository.testBlobPrefix(seed));
        }
        catch (IOException exp) {
            throw new RepositoryVerificationException(this.repositoryName, "cannot delete test data at " + this.basePath(), exp);
        }
    }

    public static String testBlobPrefix(String seed) {
        return TESTS_FILE + seed;
    }
}

