/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.mlt;

import org.elasticsearch.action.mlt.MoreLikeThisRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestToXContentListener;
import org.elasticsearch.search.Scroll;

public class RestMoreLikeThisAction
extends BaseRestHandler {
    @Inject
    public RestMoreLikeThisAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_mlt", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_mlt", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        MoreLikeThisRequest mltRequest = Requests.moreLikeThisRequest(request.param("index")).type(request.param("type")).id(request.param("id"));
        mltRequest.routing(request.param("routing"));
        mltRequest.listenerThreaded(false);
        mltRequest.fields(request.paramAsStringArray("mlt_fields", null));
        mltRequest.percentTermsToMatch(request.paramAsFloat("percent_terms_to_match", -1.0f));
        mltRequest.minTermFreq(request.paramAsInt("min_term_freq", -1));
        mltRequest.maxQueryTerms(request.paramAsInt("max_query_terms", -1));
        mltRequest.stopWords(request.paramAsStringArray("stop_words", null));
        mltRequest.minDocFreq(request.paramAsInt("min_doc_freq", -1));
        mltRequest.maxDocFreq(request.paramAsInt("max_doc_freq", -1));
        mltRequest.minWordLength(request.paramAsInt("min_word_len", request.paramAsInt("min_word_length", -1)));
        mltRequest.maxWordLength(request.paramAsInt("max_word_len", request.paramAsInt("max_word_length", -1)));
        mltRequest.boostTerms(request.paramAsFloat("boost_terms", -1.0f));
        mltRequest.include(request.paramAsBoolean("include", false));
        mltRequest.searchType(SearchType.fromString(request.param("search_type")));
        mltRequest.searchIndices(request.paramAsStringArray("search_indices", null));
        mltRequest.searchTypes(request.paramAsStringArray("search_types", null));
        mltRequest.searchSize(request.paramAsInt("search_size", mltRequest.searchSize()));
        mltRequest.searchFrom(request.paramAsInt("search_from", mltRequest.searchFrom()));
        String searchScroll = request.param("search_scroll");
        if (searchScroll != null) {
            mltRequest.searchScroll(new Scroll(TimeValue.parseTimeValue(searchScroll, null)));
        }
        if (request.hasContent()) {
            mltRequest.searchSource(request.content(), request.contentUnsafe());
        } else {
            String searchSource = request.param("search_source");
            if (searchSource != null) {
                mltRequest.searchSource(searchSource);
            }
        }
        client.moreLikeThis(mltRequest, new RestToXContentListener<SearchResponse>(channel));
    }
}

