/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.support;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.action.support.RestResponseListener;

public abstract class RestActionListener<Response>
implements ActionListener<Response> {
    private static ESLogger logger = Loggers.getLogger(RestResponseListener.class);
    protected final RestChannel channel;

    protected RestActionListener(RestChannel channel) {
        this.channel = channel;
    }

    @Override
    public final void onResponse(Response response) {
        try {
            this.processResponse(response);
        }
        catch (Throwable t) {
            this.onFailure(t);
        }
    }

    protected abstract void processResponse(Response var1) throws Exception;

    @Override
    public final void onFailure(Throwable e) {
        try {
            this.channel.sendResponse(new BytesRestResponse(this.channel, e));
        }
        catch (Throwable e1) {
            logger.error("failed to send failure response", e1, new Object[0]);
        }
    }
}

