/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.termvector;

import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.action.termvector.TermVectorRequest;
import org.elasticsearch.action.termvector.TermVectorResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.support.RestToXContentListener;

public class RestTermVectorAction
extends BaseRestHandler {
    @Inject
    public RestTermVectorAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_termvector", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_termvector", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}/_termvector", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/{id}/_termvector", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
        TermVectorRequest termVectorRequest = new TermVectorRequest(request.param("index"), request.param("type"), request.param("id"));
        Releasable parser = null;
        if (request.hasContent()) {
            try {
                parser = XContentFactory.xContent(request.content()).createParser(request.content());
                TermVectorRequest.parseRequest(termVectorRequest, (XContentParser)parser);
            }
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
        }
        RestTermVectorAction.readURIParameters(termVectorRequest, request);
        client.termVector(termVectorRequest, new RestToXContentListener<TermVectorResponse>(channel));
    }

    public static void readURIParameters(TermVectorRequest termVectorRequest, RestRequest request) {
        String fields = request.param("fields");
        RestTermVectorAction.addFieldStringsFromParameter(termVectorRequest, fields);
        termVectorRequest.offsets(request.paramAsBoolean("offsets", termVectorRequest.offsets()));
        termVectorRequest.positions(request.paramAsBoolean("positions", termVectorRequest.positions()));
        termVectorRequest.payloads(request.paramAsBoolean("payloads", termVectorRequest.payloads()));
        termVectorRequest.routing(request.param("routing"));
        termVectorRequest.parent(request.param("parent"));
        termVectorRequest.preference(request.param("preference"));
        termVectorRequest.termStatistics(request.paramAsBoolean("termStatistics", termVectorRequest.termStatistics()));
        termVectorRequest.termStatistics(request.paramAsBoolean("term_statistics", termVectorRequest.termStatistics()));
        termVectorRequest.fieldStatistics(request.paramAsBoolean("fieldStatistics", termVectorRequest.fieldStatistics()));
        termVectorRequest.fieldStatistics(request.paramAsBoolean("field_statistics", termVectorRequest.fieldStatistics()));
    }

    public static void addFieldStringsFromParameter(TermVectorRequest termVectorRequest, String fields) {
        Set<String> selectedFields = termVectorRequest.selectedFields();
        if (fields != null) {
            String[] paramFieldStrings;
            for (String field : paramFieldStrings = Strings.commaDelimitedListToStringArray(fields)) {
                if (selectedFields == null) {
                    selectedFields = new HashSet<String>();
                }
                if (selectedFields.contains(field)) continue;
                field = field.replaceAll("\\s", "");
                selectedFields.add(field);
            }
        }
        if (selectedFields != null) {
            termVectorRequest.selectedFields(selectedFields.toArray(new String[selectedFields.size()]));
        }
    }
}

