/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filters.InternalFilters;
import org.elasticsearch.search.builder.SearchSourceBuilderException;

public class FiltersAggregationBuilder
extends AggregationBuilder<FiltersAggregationBuilder> {
    private Map<String, FilterBuilder> keyedFilters = null;
    private List<FilterBuilder> nonKeyedFilters = null;

    public FiltersAggregationBuilder(String name) {
        super(name, InternalFilters.TYPE.name());
    }

    public FiltersAggregationBuilder filter(String key, FilterBuilder filter) {
        if (this.keyedFilters == null) {
            this.keyedFilters = new LinkedHashMap<String, FilterBuilder>();
        }
        this.keyedFilters.put(key, filter);
        return this;
    }

    public FiltersAggregationBuilder filter(FilterBuilder filter) {
        if (this.nonKeyedFilters == null) {
            this.nonKeyedFilters = new ArrayList<FilterBuilder>();
        }
        this.nonKeyedFilters.add(filter);
        return this;
    }

    @Override
    protected XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.keyedFilters == null && this.nonKeyedFilters == null) {
            throw new SearchSourceBuilderException("At least one filter must be set on filter aggregation [" + this.getName() + "]");
        }
        if (this.keyedFilters != null && this.nonKeyedFilters != null) {
            throw new SearchSourceBuilderException("Cannot add both keyed and non-keyed filters to filters aggregation");
        }
        if (this.keyedFilters != null) {
            builder.startObject("filters");
            for (Map.Entry entry : this.keyedFilters.entrySet()) {
                builder.field((String)entry.getKey());
                ((FilterBuilder)entry.getValue()).toXContent(builder, params);
            }
            builder.endObject();
        }
        if (this.nonKeyedFilters != null) {
            builder.startArray("filters");
            for (FilterBuilder filterBuilder : this.nonKeyedFilters) {
                filterBuilder.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder.endObject();
    }
}

