/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.joda.DateMathParser;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.rounding.DateTimeUnit;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.rounding.TimeZoneRounding;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramAggregator;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceParser;
import org.elasticsearch.search.internal.SearchContext;

public class DateHistogramParser
implements Aggregator.Parser {
    static final ParseField EXTENDED_BOUNDS = new ParseField("extended_bounds", new String[0]);
    private final ImmutableMap<String, DateTimeUnit> dateFieldUnits = MapBuilder.newMapBuilder().put("year", DateTimeUnit.YEAR_OF_CENTURY).put("1y", DateTimeUnit.YEAR_OF_CENTURY).put("quarter", DateTimeUnit.QUARTER).put("1q", DateTimeUnit.QUARTER).put("month", DateTimeUnit.MONTH_OF_YEAR).put("1M", DateTimeUnit.MONTH_OF_YEAR).put("week", DateTimeUnit.WEEK_OF_WEEKYEAR).put("1w", DateTimeUnit.WEEK_OF_WEEKYEAR).put("day", DateTimeUnit.DAY_OF_MONTH).put("1d", DateTimeUnit.DAY_OF_MONTH).put("hour", DateTimeUnit.HOUR_OF_DAY).put("1h", DateTimeUnit.HOUR_OF_DAY).put("minute", DateTimeUnit.MINUTES_OF_HOUR).put("1m", DateTimeUnit.MINUTES_OF_HOUR).put("second", DateTimeUnit.SECOND_OF_MINUTE).put("1s", DateTimeUnit.SECOND_OF_MINUTE).immutableMap();

    @Override
    public String type() {
        return InternalDateHistogram.TYPE.name();
    }

    @Override
    public AggregatorFactory parse(String aggregationName, XContentParser parser, SearchContext context) throws IOException {
        XContentParser.Token token;
        ValuesSourceParser<ValuesSource.Numeric> vsParser = ValuesSourceParser.numeric(aggregationName, InternalDateHistogram.TYPE, context).targetValueType(ValueType.DATE).formattable(true).build();
        boolean keyed = false;
        long minDocCount = 1L;
        ExtendedBounds extendedBounds = null;
        InternalOrder order = (InternalOrder)Histogram.Order.KEY_ASC;
        String interval = null;
        boolean preZoneAdjustLargeInterval = false;
        DateTimeZone preZone = DateTimeZone.UTC;
        DateTimeZone postZone = DateTimeZone.UTC;
        long preOffset = 0L;
        long postOffset = 0L;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (vsParser.token(currentFieldName, token, parser)) continue;
            if (token == XContentParser.Token.VALUE_STRING) {
                if ("time_zone".equals(currentFieldName) || "timeZone".equals(currentFieldName)) {
                    preZone = DateMathParser.parseZone(parser.text());
                    continue;
                }
                if ("pre_zone".equals(currentFieldName) || "preZone".equals(currentFieldName)) {
                    preZone = DateMathParser.parseZone(parser.text());
                    continue;
                }
                if ("post_zone".equals(currentFieldName) || "postZone".equals(currentFieldName)) {
                    postZone = DateMathParser.parseZone(parser.text());
                    continue;
                }
                if ("pre_offset".equals(currentFieldName) || "preOffset".equals(currentFieldName)) {
                    preOffset = this.parseOffset(parser.text());
                    continue;
                }
                if ("post_offset".equals(currentFieldName) || "postOffset".equals(currentFieldName)) {
                    postOffset = this.parseOffset(parser.text());
                    continue;
                }
                if ("interval".equals(currentFieldName)) {
                    interval = parser.text();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                if ("keyed".equals(currentFieldName)) {
                    keyed = parser.booleanValue();
                    continue;
                }
                if ("pre_zone_adjust_large_interval".equals(currentFieldName) || "preZoneAdjustLargeInterval".equals(currentFieldName)) {
                    preZoneAdjustLargeInterval = parser.booleanValue();
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if ("min_doc_count".equals(currentFieldName) || "minDocCount".equals(currentFieldName)) {
                    minDocCount = parser.longValue();
                    continue;
                }
                if ("time_zone".equals(currentFieldName) || "timeZone".equals(currentFieldName)) {
                    preZone = DateTimeZone.forOffsetHours(parser.intValue());
                    continue;
                }
                if ("pre_zone".equals(currentFieldName) || "preZone".equals(currentFieldName)) {
                    preZone = DateTimeZone.forOffsetHours(parser.intValue());
                    continue;
                }
                if ("post_zone".equals(currentFieldName) || "postZone".equals(currentFieldName)) {
                    postZone = DateTimeZone.forOffsetHours(parser.intValue());
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("order".equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token != XContentParser.Token.VALUE_STRING) continue;
                        String dir = parser.text();
                        boolean asc = "asc".equals(dir);
                        order = DateHistogramParser.resolveOrder(currentFieldName, asc);
                    }
                    continue;
                }
                if (EXTENDED_BOUNDS.match(currentFieldName)) {
                    extendedBounds = new ExtendedBounds();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            if ("min".equals(currentFieldName)) {
                                extendedBounds.minAsStr = parser.text();
                                continue;
                            }
                            if ("max".equals(currentFieldName)) {
                                extendedBounds.maxAsStr = parser.text();
                                continue;
                            }
                            throw new SearchParseException(context, "Unknown extended_bounds key for a " + (Object)((Object)token) + " in aggregation [" + aggregationName + "]: [" + currentFieldName + "].");
                        }
                        if (token == XContentParser.Token.VALUE_NUMBER) {
                            if ("min".equals(currentFieldName)) {
                                extendedBounds.min = parser.longValue();
                                continue;
                            }
                            if ("max".equals(currentFieldName)) {
                                extendedBounds.max = parser.longValue();
                                continue;
                            }
                            throw new SearchParseException(context, "Unknown extended_bounds key for a " + (Object)((Object)token) + " in aggregation [" + aggregationName + "]: [" + currentFieldName + "].");
                        }
                        throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
                    }
                    continue;
                }
                throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            }
            throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " in [" + aggregationName + "].");
        }
        if (interval == null) {
            throw new SearchParseException(context, "Missing required field [interval] for histogram aggregation [" + aggregationName + "]");
        }
        DateTimeUnit dateTimeUnit = this.dateFieldUnits.get(interval);
        TimeZoneRounding.Builder tzRoundingBuilder = dateTimeUnit != null ? TimeZoneRounding.builder(dateTimeUnit) : TimeZoneRounding.builder(TimeValue.parseTimeValue(interval, null));
        Rounding rounding = tzRoundingBuilder.preZone(preZone).postZone(postZone).preZoneAdjustLargeInterval(preZoneAdjustLargeInterval).preOffset(preOffset).postOffset(postOffset).build();
        return new HistogramAggregator.Factory(aggregationName, vsParser.config(), rounding, order, keyed, minDocCount, extendedBounds, InternalDateHistogram.FACTORY);
    }

    private static InternalOrder resolveOrder(String key, boolean asc) {
        if ("_key".equals(key) || "_time".equals(key)) {
            return (InternalOrder)(asc ? InternalOrder.KEY_ASC : InternalOrder.KEY_DESC);
        }
        if ("_count".equals(key)) {
            return (InternalOrder)(asc ? InternalOrder.COUNT_ASC : InternalOrder.COUNT_DESC);
        }
        return new InternalOrder.Aggregation(key, asc);
    }

    private long parseOffset(String offset) throws IOException {
        if (offset.charAt(0) == '-') {
            return -TimeValue.parseTimeValue(offset.substring(1), null).millis();
        }
        int beginIndex = offset.charAt(0) == '+' ? 1 : 0;
        return TimeValue.parseTimeValue(offset.substring(beginIndex), null).millis();
    }
}

