/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.aggregations.bucket.terms.AbstractTermsParametersParser;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.internal.SearchContext;

public class TermsParametersParser
extends AbstractTermsParametersParser {
    private static final TermsAggregator.BucketCountThresholds DEFAULT_BUCKET_COUNT_THRESHOLDS = new TermsAggregator.BucketCountThresholds(1L, 0L, 10, -1);
    String orderKey = "_count";
    boolean orderAsc = false;
    private boolean showTermDocCountError = false;

    public String getOrderKey() {
        return this.orderKey;
    }

    public boolean isOrderAsc() {
        return this.orderAsc;
    }

    public boolean showTermDocCountError() {
        return this.showTermDocCountError;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void parseSpecial(String aggregationName, XContentParser parser, SearchContext context, XContentParser.Token token, String currentFieldName) throws IOException {
        if (token == XContentParser.Token.START_OBJECT) {
            if (!"order".equals(currentFieldName)) throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    this.orderKey = parser.currentName();
                    continue;
                }
                if (token != XContentParser.Token.VALUE_STRING) throw new SearchParseException(context, "Unexpected token " + (Object)((Object)token) + " for [order] in [" + aggregationName + "].");
                String dir = parser.text();
                if ("asc".equalsIgnoreCase(dir)) {
                    this.orderAsc = true;
                    continue;
                }
                if (!"desc".equalsIgnoreCase(dir)) throw new SearchParseException(context, "Unknown terms order direction [" + dir + "] in terms aggregation [" + aggregationName + "]");
                this.orderAsc = false;
            }
            return;
        } else {
            if (token != XContentParser.Token.VALUE_BOOLEAN) throw new SearchParseException(context, "Unknown key for a " + (Object)((Object)token) + " in [" + aggregationName + "]: [" + currentFieldName + "].");
            if (!SHOW_TERM_DOC_COUNT_ERROR.match(currentFieldName)) return;
            this.showTermDocCountError = parser.booleanValue();
        }
    }

    @Override
    public TermsAggregator.BucketCountThresholds getDefaultBucketCountThresholds() {
        return new TermsAggregator.BucketCountThresholds(DEFAULT_BUCKET_COUNT_THRESHOLDS);
    }
}

