/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.cardinality;

import java.io.IOException;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.base.Preconditions;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.cardinality.HyperLogLogPlusPlus;
import org.elasticsearch.search.aggregations.metrics.cardinality.InternalCardinality;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;

public class CardinalityAggregator
extends NumericMetricsAggregator.SingleValue {
    private final int precision;
    private final boolean rehash;
    private final ValuesSource valuesSource;
    @Nullable
    private HyperLogLogPlusPlus counts;
    private Collector collector;

    public CardinalityAggregator(String name, long estimatedBucketsCount, ValuesSource valuesSource, boolean rehash, int precision, AggregationContext context, Aggregator parent) {
        super(name, estimatedBucketsCount, context, parent);
        this.valuesSource = valuesSource;
        this.rehash = rehash;
        this.precision = precision;
        this.counts = valuesSource == null ? null : new HyperLogLogPlusPlus(precision, this.bigArrays, estimatedBucketsCount);
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.postCollectLastCollector();
        this.collector = this.createCollector(reader);
    }

    private Collector createCollector(AtomicReaderContext reader) {
        if (!this.rehash) {
            MurmurHash3Values hashValues = MurmurHash3Values.cast(((ValuesSource.Numeric)this.valuesSource).longValues());
            return new DirectCollector(this.counts, hashValues);
        }
        if (this.valuesSource instanceof ValuesSource.Numeric) {
            ValuesSource.Numeric source = (ValuesSource.Numeric)this.valuesSource;
            MurmurHash3Values hashValues = source.isFloatingPoint() ? MurmurHash3Values.hash(source.doubleValues()) : MurmurHash3Values.hash(source.longValues());
            return new DirectCollector(this.counts, hashValues);
        }
        if (this.valuesSource instanceof ValuesSource.Bytes.WithOrdinals) {
            long countsMemoryUsage;
            ValuesSource.Bytes.WithOrdinals source = (ValuesSource.Bytes.WithOrdinals)this.valuesSource;
            RandomAccessOrds ordinalValues = source.ordinalsValues();
            long maxOrd = ordinalValues.getValueCount();
            if (maxOrd == 0L) {
                return new EmptyCollector();
            }
            long ordinalsMemoryUsage = OrdinalsCollector.memoryOverhead(maxOrd);
            if (ordinalsMemoryUsage < (countsMemoryUsage = HyperLogLogPlusPlus.memoryUsage(this.precision)) / 4L) {
                return new OrdinalsCollector(this.counts, ordinalValues, this.bigArrays);
            }
        }
        return new DirectCollector(this.counts, MurmurHash3Values.hash(this.valuesSource.bytesValues()));
    }

    @Override
    public boolean shouldCollect() {
        return this.valuesSource != null;
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        this.collector.collect(doc, owningBucketOrdinal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postCollectLastCollector() {
        if (this.collector != null) {
            try {
                this.collector.postCollect();
                this.collector.close();
            }
            finally {
                this.collector = null;
            }
        }
    }

    @Override
    protected void doPostCollection() {
        this.postCollectLastCollector();
    }

    @Override
    public double metric(long owningBucketOrd) {
        return this.counts == null ? 0.0 : (double)this.counts.cardinality(owningBucketOrd);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        if (this.counts == null || owningBucketOrdinal >= this.counts.maxBucket() || this.counts.cardinality(owningBucketOrdinal) == 0L) {
            return this.buildEmptyAggregation();
        }
        HyperLogLogPlusPlus copy = new HyperLogLogPlusPlus(this.precision, BigArrays.NON_RECYCLING_INSTANCE, 1L);
        copy.merge(0L, this.counts, owningBucketOrdinal);
        return new InternalCardinality(this.name, copy);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalCardinality(this.name, null);
    }

    @Override
    protected void doClose() {
        Releasables.close(this.counts, this.collector);
    }

    static abstract class MurmurHash3Values {
        MurmurHash3Values() {
        }

        public abstract void setDocument(int var1);

        public abstract int count();

        public abstract long valueAt(int var1);

        public static MurmurHash3Values cast(final SortedNumericDocValues values) {
            return new MurmurHash3Values(){

                @Override
                public void setDocument(int docId) {
                    values.setDocument(docId);
                }

                @Override
                public int count() {
                    return values.count();
                }

                @Override
                public long valueAt(int index) {
                    return values.valueAt(index);
                }
            };
        }

        public static MurmurHash3Values hash(SortedNumericDoubleValues values) {
            return new Double(values);
        }

        public static MurmurHash3Values hash(SortedNumericDocValues values) {
            return new Long(values);
        }

        public static MurmurHash3Values hash(SortedBinaryDocValues values) {
            return new Bytes(values);
        }

        private static class Bytes
        extends MurmurHash3Values {
            private final MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
            private final SortedBinaryDocValues values;

            public Bytes(SortedBinaryDocValues values) {
                this.values = values;
            }

            @Override
            public void setDocument(int docId) {
                this.values.setDocument(docId);
            }

            @Override
            public int count() {
                return this.values.count();
            }

            @Override
            public long valueAt(int index) {
                BytesRef bytes = this.values.valueAt(index);
                MurmurHash3.hash128(bytes.bytes, bytes.offset, bytes.length, 0L, this.hash);
                return this.hash.h1;
            }
        }

        private static class Double
        extends MurmurHash3Values {
            private final SortedNumericDoubleValues values;

            public Double(SortedNumericDoubleValues values) {
                this.values = values;
            }

            @Override
            public void setDocument(int docId) {
                this.values.setDocument(docId);
            }

            @Override
            public int count() {
                return this.values.count();
            }

            @Override
            public long valueAt(int index) {
                return org.elasticsearch.common.hppc.hash.MurmurHash3.hash(java.lang.Double.doubleToLongBits(this.values.valueAt(index)));
            }
        }

        private static class Long
        extends MurmurHash3Values {
            private final SortedNumericDocValues values;

            public Long(SortedNumericDocValues values) {
                this.values = values;
            }

            @Override
            public void setDocument(int docId) {
                this.values.setDocument(docId);
            }

            @Override
            public int count() {
                return this.values.count();
            }

            @Override
            public long valueAt(int index) {
                return org.elasticsearch.common.hppc.hash.MurmurHash3.hash(this.values.valueAt(index));
            }
        }
    }

    private static class OrdinalsCollector
    implements Collector {
        private static final long SHALLOW_FIXEDBITSET_SIZE = RamUsageEstimator.shallowSizeOfInstance(FixedBitSet.class);
        private final BigArrays bigArrays;
        private final RandomAccessOrds values;
        private final int maxOrd;
        private final HyperLogLogPlusPlus counts;
        private ObjectArray<FixedBitSet> visitedOrds;

        public static long memoryOverhead(long maxOrd) {
            return (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + SHALLOW_FIXEDBITSET_SIZE + (maxOrd + 7L) / 8L;
        }

        OrdinalsCollector(HyperLogLogPlusPlus counts, RandomAccessOrds values, BigArrays bigArrays) {
            Preconditions.checkArgument(values.getValueCount() <= Integer.MAX_VALUE);
            this.maxOrd = (int)values.getValueCount();
            this.bigArrays = bigArrays;
            this.counts = counts;
            this.values = values;
            this.visitedOrds = bigArrays.newObjectArray(1L);
        }

        @Override
        public void collect(int doc, long bucketOrd) {
            this.visitedOrds = this.bigArrays.grow(this.visitedOrds, bucketOrd + 1L);
            FixedBitSet bits = this.visitedOrds.get(bucketOrd);
            if (bits == null) {
                bits = new FixedBitSet(this.maxOrd);
                this.visitedOrds.set(bucketOrd, bits);
            }
            this.values.setDocument(doc);
            int valueCount = this.values.cardinality();
            for (int i = 0; i < valueCount; ++i) {
                bits.set((int)this.values.ordAt(i));
            }
        }

        @Override
        public void postCollect() {
            FixedBitSet allVisitedOrds = new FixedBitSet(this.maxOrd);
            for (long bucket = this.visitedOrds.size() - 1L; bucket >= 0L; --bucket) {
                FixedBitSet bits = this.visitedOrds.get(bucket);
                if (bits == null) continue;
                allVisitedOrds.or(bits);
            }
            MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
            try (LongArray hashes = this.bigArrays.newLongArray(this.maxOrd, false);){
                int ord = allVisitedOrds.nextSetBit(0);
                while (ord != -1) {
                    BytesRef value = this.values.lookupOrd((long)ord);
                    MurmurHash3.hash128(value.bytes, value.offset, value.length, 0L, hash);
                    hashes.set(ord, hash.h1);
                    ord = ord + 1 < this.maxOrd ? allVisitedOrds.nextSetBit(ord + 1) : -1;
                }
                for (long bucket = this.visitedOrds.size() - 1L; bucket >= 0L; --bucket) {
                    FixedBitSet bits = this.visitedOrds.get(bucket);
                    if (bits == null) continue;
                    int ord2 = bits.nextSetBit(0);
                    while (ord2 != -1) {
                        this.counts.collect(bucket, hashes.get(ord2));
                        ord2 = ord2 + 1 < this.maxOrd ? bits.nextSetBit(ord2 + 1) : -1;
                    }
                }
            }
        }

        @Override
        public void close() throws ElasticsearchException {
            Releasables.close(this.visitedOrds);
        }
    }

    private static class DirectCollector
    implements Collector {
        private final MurmurHash3Values hashes;
        private final HyperLogLogPlusPlus counts;

        DirectCollector(HyperLogLogPlusPlus counts, MurmurHash3Values values) {
            this.counts = counts;
            this.hashes = values;
        }

        @Override
        public void collect(int doc, long bucketOrd) {
            this.hashes.setDocument(doc);
            int valueCount = this.hashes.count();
            for (int i = 0; i < valueCount; ++i) {
                this.counts.collect(bucketOrd, this.hashes.valueAt(i));
            }
        }

        @Override
        public void postCollect() {
        }

        @Override
        public void close() throws ElasticsearchException {
        }
    }

    private static class EmptyCollector
    implements Collector {
        private EmptyCollector() {
        }

        @Override
        public void collect(int doc, long bucketOrd) {
        }

        @Override
        public void postCollect() {
        }

        @Override
        public void close() throws ElasticsearchException {
        }
    }

    private static interface Collector
    extends Releasable {
        public void collect(int var1, long var2);

        public void postCollect();
    }
}

