/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics.percentiles;

import java.io.IOException;
import java.util.Iterator;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.percentiles.AbstractInternalPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.InternalPercentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.Percentile;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.TDigestState;

public class InternalPercentileRanks
extends AbstractInternalPercentiles
implements PercentileRanks {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("percentile_ranks");
    public static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalPercentileRanks readResult(StreamInput in) throws IOException {
            InternalPercentileRanks result = new InternalPercentileRanks();
            result.readFrom(in);
            return result;
        }
    };

    public static void registerStreams() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
    }

    InternalPercentileRanks() {
    }

    public InternalPercentileRanks(String name, double[] cdfValues, TDigestState state, boolean keyed) {
        super(name, cdfValues, state, keyed);
    }

    @Override
    public Iterator<Percentile> iterator() {
        return new Iter(this.keys, this.state);
    }

    @Override
    public double percent(double value) {
        return InternalPercentileRanks.percentileRank(this.state, value);
    }

    @Override
    public double value(double key) {
        return this.percent(key);
    }

    @Override
    protected AbstractInternalPercentiles createReduced(String name, double[] keys, TDigestState merged, boolean keyed) {
        return new InternalPercentileRanks(name, keys, merged, keyed);
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    static double percentileRank(TDigestState state, double value) {
        double percentileRank = state.cdf(value);
        if (percentileRank < 0.0) {
            percentileRank = 0.0;
        } else if (percentileRank > 1.0) {
            percentileRank = 1.0;
        }
        return percentileRank * 100.0;
    }

    public static class Iter
    extends UnmodifiableIterator<Percentile> {
        private final double[] values;
        private final TDigestState state;
        private int i;

        public Iter(double[] values, TDigestState state) {
            this.values = values;
            this.state = state;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.values.length;
        }

        @Override
        public Percentile next() {
            InternalPercentile next = new InternalPercentile(InternalPercentileRanks.percentileRank(this.state, this.values[this.i]), this.values[this.i]);
            ++this.i;
            return next;
        }
    }
}

