/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.nested;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.lucene.docset.ContextDocIdSet;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.FilteredCollector;
import org.elasticsearch.common.lucene.search.XCollector;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.search.SearchParseException;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.internal.SearchContext;

public class NestedFacetExecutor
extends FacetExecutor {
    private final FacetExecutor facetExecutor;
    private final FixedBitSetFilter parentFilter;
    private final FixedBitSetFilter childFilter;

    public NestedFacetExecutor(FacetExecutor facetExecutor, SearchContext context, String nestedPath) {
        this.facetExecutor = facetExecutor;
        MapperService.SmartNameObjectMapper mapper = context.smartNameObjectMapper(nestedPath);
        if (mapper == null) {
            throw new SearchParseException(context, "facet nested path [" + nestedPath + "] not found");
        }
        ObjectMapper objectMapper = mapper.mapper();
        if (objectMapper == null) {
            throw new SearchParseException(context, "facet nested path [" + nestedPath + "] not found");
        }
        if (!objectMapper.nested().isNested()) {
            throw new SearchParseException(context, "facet nested path [" + nestedPath + "] is not nested");
        }
        this.parentFilter = context.fixedBitSetFilterCache().getFixedBitSetFilter(NonNestedDocsFilter.INSTANCE);
        this.childFilter = context.fixedBitSetFilterCache().getFixedBitSetFilter(objectMapper.nestedTypeFilter());
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        return this.facetExecutor.buildFacet(facetName);
    }

    @Override
    public Collector collector() {
        FacetExecutor.Collector collector = this.facetExecutor.collector();
        if (collector == null) {
            return null;
        }
        return new Collector(collector, this.parentFilter, this.childFilter);
    }

    @Override
    public Post post() {
        FacetExecutor.Post post = this.facetExecutor.post();
        if (post == null) {
            return null;
        }
        return new Post(post, this.parentFilter, this.childFilter);
    }

    public static class Collector
    extends FacetExecutor.Collector {
        private final org.apache.lucene.search.Collector collector;
        private final Filter parentFilter;
        private final Filter childFilter;
        private Bits childDocs;
        private FixedBitSet parentDocs;

        public Collector(Collector collector, Filter filter) {
            this.collector = new FilteredCollector(collector.collector, filter);
            this.parentFilter = collector.parentFilter;
            this.childFilter = collector.childFilter;
        }

        public Collector(org.apache.lucene.search.Collector collector, Filter parentFilter, Filter childFilter) {
            this.collector = collector;
            this.parentFilter = parentFilter;
            this.childFilter = childFilter;
        }

        @Override
        public void postCollection() throws IOException {
            if (this.collector instanceof XCollector) {
                ((XCollector)this.collector).postCollection();
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.collector.setScorer(scorer);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.collector.setNextReader(context);
            DocIdSet docIdSet = this.parentFilter.getDocIdSet(context, null);
            this.childDocs = DocIdSets.toSafeBits(context.reader(), this.childFilter.getDocIdSet(context, null));
            this.parentDocs = DocIdSets.isEmpty(docIdSet) ? null : (FixedBitSet)docIdSet;
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return this.collector.acceptsDocsOutOfOrder();
        }

        public void collect(int parentDoc) throws IOException {
            if (parentDoc == 0 || this.parentDocs == null) {
                return;
            }
            int prevParentDoc = this.parentDocs.prevSetBit(parentDoc - 1);
            for (int i = parentDoc - 1; i > prevParentDoc; --i) {
                if (!this.childDocs.get(i)) continue;
                this.collector.collect(i);
            }
        }
    }

    public static class Post
    extends FacetExecutor.Post {
        private final FacetExecutor.Post post;
        private final Filter parentFilter;
        private final Filter childFilter;

        public Post(FacetExecutor.Post post, Filter parentFilter, Filter childFilter) {
            this.post = post;
            this.parentFilter = parentFilter;
            this.childFilter = childFilter;
        }

        public Post(Post post, Filter filter) {
            this.post = new FacetExecutor.Post.Filtered(post.post, filter);
            this.parentFilter = post.parentFilter;
            this.childFilter = post.childFilter;
        }

        @Override
        public void executePost(List<ContextDocIdSet> docSets) throws IOException {
            ArrayList<ContextDocIdSet> nestedEntries = new ArrayList<ContextDocIdSet>(docSets.size());
            for (int i = 0; i < docSets.size(); ++i) {
                ContextDocIdSet entry = docSets.get(i);
                AtomicReaderContext context = entry.context;
                DocIdSet docIdSet = this.parentFilter.getDocIdSet(context, null);
                if (DocIdSets.isEmpty(docIdSet)) continue;
                Bits childDocs = DocIdSets.toSafeBits(context.reader(), this.childFilter.getDocIdSet(context, null));
                FixedBitSet parentDocs = (FixedBitSet)docIdSet;
                DocIdSetIterator iter = entry.docSet.iterator();
                int parentDoc = iter.nextDoc();
                if (parentDoc == Integer.MAX_VALUE) continue;
                if (parentDoc == 0) {
                    parentDoc = iter.nextDoc();
                }
                if (parentDoc == Integer.MAX_VALUE) continue;
                FixedBitSet childSet = new FixedBitSet(context.reader().maxDoc());
                do {
                    int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                    for (int childDocId = parentDoc - 1; childDocId > prevParentDoc; --childDocId) {
                        if (!childDocs.get(childDocId)) continue;
                        childSet.set(childDocId);
                    }
                } while ((parentDoc = iter.nextDoc()) != Integer.MAX_VALUE);
                nestedEntries.add(new ContextDocIdSet(entry.context, (DocIdSet)childSet));
            }
            this.post.executePost(nestedEntries);
        }
    }
}

