/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.cache.fixedbitset.FixedBitSetFilter;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.ObjectMappers;
import org.elasticsearch.index.mapper.object.ObjectMapper;
import org.elasticsearch.index.query.ParsedFilter;
import org.elasticsearch.index.search.nested.NonNestedDocsFilter;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortParser;

public class GeoDistanceSortParser
implements SortParser {
    @Override
    public String[] names() {
        return new String[]{"_geo_distance", "_geoDistance"};
    }

    @Override
    public SortField parse(XContentParser parser, SearchContext context) throws Exception {
        IndexFieldData.XFieldComparatorSource.Nested nested;
        ObjectMapper objectMapper;
        XContentParser.Token token;
        String fieldName = null;
        ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>();
        DistanceUnit unit = DistanceUnit.DEFAULT;
        GeoDistance geoDistance = GeoDistance.DEFAULT;
        boolean reverse = false;
        MultiValueMode sortMode = null;
        String nestedPath = null;
        Filter nestedFilter = null;
        boolean normalizeLon = true;
        boolean normalizeLat = true;
        String currentName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            GeoPoint point;
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                this.parseGeoPoints(parser, geoPoints);
                fieldName = currentName;
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if ("nested_filter".equals(currentName) || "nestedFilter".equals(currentName)) {
                    ParsedFilter parsedFilter = context.queryParserService().parseInnerFilter(parser);
                    nestedFilter = parsedFilter == null ? null : parsedFilter.filter();
                    continue;
                }
                fieldName = currentName;
                point = new GeoPoint();
                GeoUtils.parseGeoPoint(parser, point);
                geoPoints.add(point);
                continue;
            }
            if (!token.isValue()) continue;
            if ("reverse".equals(currentName)) {
                reverse = parser.booleanValue();
                continue;
            }
            if ("order".equals(currentName)) {
                reverse = "desc".equals(parser.text());
                continue;
            }
            if (currentName.equals("unit")) {
                unit = DistanceUnit.fromString(parser.text());
                continue;
            }
            if (currentName.equals("distance_type") || currentName.equals("distanceType")) {
                geoDistance = GeoDistance.fromString(parser.text());
                continue;
            }
            if ("normalize".equals(currentName)) {
                normalizeLat = parser.booleanValue();
                normalizeLon = parser.booleanValue();
                continue;
            }
            if ("sort_mode".equals(currentName) || "sortMode".equals(currentName) || "mode".equals(currentName)) {
                sortMode = MultiValueMode.fromString(parser.text());
                continue;
            }
            if ("nested_path".equals(currentName) || "nestedPath".equals(currentName)) {
                nestedPath = parser.text();
                continue;
            }
            point = new GeoPoint();
            point.resetFromString(parser.text());
            geoPoints.add(point);
            fieldName = currentName;
        }
        if (normalizeLat || normalizeLon) {
            for (GeoPoint point : geoPoints) {
                GeoUtils.normalizePoint(point, normalizeLat, normalizeLon);
            }
        }
        if (sortMode == null) {
            MultiValueMode multiValueMode = sortMode = reverse ? MultiValueMode.MAX : MultiValueMode.MIN;
        }
        if (sortMode == MultiValueMode.SUM) {
            throw new ElasticsearchIllegalArgumentException("sort_mode [sum] isn't supported for sorting by geo distance");
        }
        FieldMapper mapper = context.smartNameFieldMapper(fieldName);
        if (mapper == null) {
            throw new ElasticsearchIllegalArgumentException("failed to find mapper for [" + fieldName + "] for geo distance based sort");
        }
        final MultiValueMode finalSortMode = sortMode;
        final IndexGeoPointFieldData geoIndexFieldData = (IndexGeoPointFieldData)context.fieldData().getForField(mapper);
        final GeoDistance.FixedSourceDistance[] distances = new GeoDistance.FixedSourceDistance[geoPoints.size()];
        for (int i = 0; i < geoPoints.size(); ++i) {
            distances[i] = geoDistance.fixedSourceDistance(((GeoPoint)geoPoints.get(i)).lat(), ((GeoPoint)geoPoints.get(i)).lon(), unit);
        }
        if (nestedPath != null) {
            ObjectMappers objectMappers = context.mapperService().objectMapper(nestedPath);
            if (objectMappers == null) {
                throw new ElasticsearchIllegalArgumentException("failed to find nested object mapping for explicit nested path [" + nestedPath + "]");
            }
            objectMapper = objectMappers.mapper();
            if (!objectMapper.nested().isNested()) {
                throw new ElasticsearchIllegalArgumentException("mapping for explicit nested path is not mapped as nested: [" + nestedPath + "]");
            }
        } else {
            objectMapper = context.mapperService().resolveClosestNestedObjectMapper(fieldName);
        }
        if (objectMapper != null && objectMapper.nested().isNested()) {
            FixedBitSetFilter rootDocumentsFilter = context.fixedBitSetFilterCache().getFixedBitSetFilter(NonNestedDocsFilter.INSTANCE);
            FixedBitSetFilter innerDocumentsFilter = nestedFilter != null ? context.fixedBitSetFilterCache().getFixedBitSetFilter(nestedFilter) : context.fixedBitSetFilterCache().getFixedBitSetFilter(objectMapper.nestedTypeFilter());
            nested = new IndexFieldData.XFieldComparatorSource.Nested(rootDocumentsFilter, innerDocumentsFilter);
        } else {
            nested = null;
        }
        IndexFieldData.XFieldComparatorSource geoDistanceComparatorSource = new IndexFieldData.XFieldComparatorSource(){

            @Override
            public SortField.Type reducedType() {
                return SortField.Type.DOUBLE;
            }

            public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
                return new FieldComparator.DoubleComparator(numHits, null, null, null){

                    protected FieldCache.Doubles getDoubleValues(AtomicReaderContext context, String field) throws IOException {
                        NumericDoubleValues selectedValues;
                        MultiGeoPointValues geoPointValues = ((AtomicGeoPointFieldData)geoIndexFieldData.load(context)).getGeoPointValues();
                        SortedNumericDoubleValues distanceValues = GeoDistance.distanceValues(geoPointValues, distances);
                        if (nested == null) {
                            selectedValues = finalSortMode.select(distanceValues, Double.MAX_VALUE);
                        } else {
                            FixedBitSet rootDocs = nested.rootDocs(context);
                            FixedBitSet innerDocs = nested.innerDocs(context);
                            selectedValues = finalSortMode.select(distanceValues, Double.MAX_VALUE, rootDocs, innerDocs, context.reader().maxDoc());
                        }
                        return new FieldCache.Doubles(){

                            public double get(int docID) {
                                return selectedValues.get(docID);
                            }
                        };
                    }
                };
            }
        };
        return new SortField(fieldName, (FieldComparatorSource)geoDistanceComparatorSource, reverse);
    }

    private void parseGeoPoints(XContentParser parser, List<GeoPoint> geoPoints) throws IOException {
        while (!parser.nextToken().equals((Object)XContentParser.Token.END_ARRAY)) {
            if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                double lon = parser.doubleValue();
                parser.nextToken();
                if (!parser.currentToken().equals((Object)XContentParser.Token.VALUE_NUMBER)) {
                    throw new ElasticsearchParseException("geo point parsing: expected second number but got" + (Object)((Object)parser.currentToken()));
                }
                double lat = parser.doubleValue();
                GeoPoint point = new GeoPoint();
                point.reset(lat, lon);
                geoPoints.add(point);
                continue;
            }
            GeoPoint point = new GeoPoint();
            GeoUtils.parseGeoPoint(parser, point);
            geoPoints.add(point);
        }
    }
}

