/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.accumulo.mapreduce;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloRowInputFormat;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.vertexium.Authorizations;
import org.vertexium.Element;
import org.vertexium.ElementType;
import org.vertexium.FetchHint;
import org.vertexium.GraphFactory;
import org.vertexium.Property;
import org.vertexium.Visibility;
import org.vertexium.accumulo.AccumuloAuthorizations;
import org.vertexium.accumulo.AccumuloGraph;
import org.vertexium.accumulo.LazyMutableProperty;
import org.vertexium.accumulo.LazyPropertyMetadata;
import org.vertexium.accumulo.iterator.model.ElementData;
import org.vertexium.accumulo.mapreduce.VertexiumMRUtils;
import org.vertexium.util.MapUtils;

public abstract class AccumuloElementInputFormatBase<TValue extends Element>
extends InputFormat<Text, TValue> {
    private final AccumuloRowInputFormat accumuloInputFormat = new AccumuloRowInputFormat();

    public static void setInputInfo(Job job, String instanceName, String zooKeepers, String principal, AuthenticationToken token, String[] authorizations, String tableName) throws AccumuloSecurityException {
        AccumuloRowInputFormat.setInputTableName((Job)job, (String)tableName);
        AccumuloRowInputFormat.setConnectorInfo((Job)job, (String)principal, (AuthenticationToken)token);
        ClientConfiguration clientConfig = new ClientConfiguration(new Configuration[0]).withInstance(instanceName).withZkHosts(zooKeepers);
        AccumuloRowInputFormat.setZooKeeperInstance((Job)job, (ClientConfiguration)clientConfig);
        AccumuloRowInputFormat.setScanAuthorizations((Job)job, (org.apache.accumulo.core.security.Authorizations)new org.apache.accumulo.core.security.Authorizations(authorizations));
        job.getConfiguration().setStrings("authorizations", authorizations);
    }

    public static void setFetchHints(Job job, ElementType elementType, EnumSet<FetchHint> fetchHints) {
        Iterable<Text> columnFamiliesToFetch = AccumuloGraph.getColumnFamiliesToFetch(elementType, fetchHints);
        ArrayList<Pair> columnFamilyColumnQualifierPairs = new ArrayList<Pair>();
        for (Text columnFamilyToFetch : columnFamiliesToFetch) {
            columnFamilyColumnQualifierPairs.add(new Pair((Object)columnFamilyToFetch, null));
        }
        AccumuloInputFormat.fetchColumns((Job)job, columnFamilyColumnQualifierPairs);
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.accumuloInputFormat.getSplits(jobContext);
    }

    public RecordReader<Text, TValue> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        final RecordReader reader = this.accumuloInputFormat.createRecordReader(inputSplit, taskAttemptContext);
        return new RecordReader<Text, TValue>(){
            public AccumuloGraph graph;
            public Authorizations authorizations;

            public void initialize(InputSplit inputSplit, TaskAttemptContext ctx) throws IOException, InterruptedException {
                reader.initialize(inputSplit, ctx);
                Map configurationMap = VertexiumMRUtils.toMap(ctx.getConfiguration());
                this.graph = (AccumuloGraph)new GraphFactory().createGraph(MapUtils.getAllWithPrefix((Map)configurationMap, (String)"graph"));
                this.authorizations = new AccumuloAuthorizations(ctx.getConfiguration().getStrings("authorizations"));
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                return reader.nextKeyValue();
            }

            public Text getCurrentKey() throws IOException, InterruptedException {
                return (Text)reader.getCurrentKey();
            }

            public TValue getCurrentValue() throws IOException, InterruptedException {
                PeekingIterator row = (PeekingIterator)reader.getCurrentValue();
                return AccumuloElementInputFormatBase.this.createElementFromRow(this.graph, (PeekingIterator<Map.Entry<Key, Value>>)row, this.authorizations);
            }

            public float getProgress() throws IOException, InterruptedException {
                return reader.getProgress();
            }

            public void close() throws IOException {
                reader.close();
            }
        };
    }

    protected abstract TValue createElementFromRow(AccumuloGraph var1, PeekingIterator<Map.Entry<Key, Value>> var2, Authorizations var3);

    protected static Iterable<Property> makePropertiesFromElementData(final AccumuloGraph graph, ElementData elementData, EnumSet<org.vertexium.accumulo.iterator.model.FetchHint> fetchHints) {
        return Iterables.transform((Iterable)elementData.getProperties(fetchHints), (Function)new Function<org.vertexium.accumulo.iterator.model.Property, Property>(){

            @Nullable
            public Property apply(@Nullable org.vertexium.accumulo.iterator.model.Property property) {
                return AccumuloElementInputFormatBase.makePropertyFromIteratorProperty(graph, property);
            }
        });
    }

    private static Property makePropertyFromIteratorProperty(AccumuloGraph graph, org.vertexium.accumulo.iterator.model.Property property) {
        LazyPropertyMetadata metadata = new LazyPropertyMetadata();
        HashSet hiddenVisibilities = null;
        if (property.hiddenVisibilities != null) {
            hiddenVisibilities = Sets.newHashSet((Iterable)Iterables.transform((Iterable)property.hiddenVisibilities, (Function)new Function<Text, Visibility>(){

                @Nullable
                public Visibility apply(Text visibilityText) {
                    return AccumuloGraph.accumuloVisibilityToVisibility(AccumuloGraph.visibilityToAccumuloVisibility(visibilityText.toString()));
                }
            }));
        }
        Visibility visibility = AccumuloGraph.accumuloVisibilityToVisibility(AccumuloGraph.visibilityToAccumuloVisibility(property.visibility));
        return new LazyMutableProperty(graph, graph.getVertexiumSerializer(), graph.getNameSubstitutionStrategy().inflate(property.key), graph.getNameSubstitutionStrategy().inflate(property.name), property.value, metadata, hiddenVisibilities, visibility, property.timestamp);
    }
}

