/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mrunit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mrunit.TestDriver;
import org.apache.hadoop.mrunit.types.Pair;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class MapReduceDriverBase<K1, V1, K2, V2, K3, V3, T extends MapReduceDriverBase<K1, V1, K2, V2, K3, V3, T>>
extends TestDriver<K3, V3, T> {
    public static final Log LOG = LogFactory.getLog(MapReduceDriverBase.class);
    protected List<Pair<K1, V1>> inputList = new ArrayList<Pair<K1, V1>>();
    protected Path mapInputPath = new Path("somefile");
    protected Comparator<K2> keyGroupComparator;
    protected Comparator<K2> keyValueOrderComparator;

    public void addInput(K1 key, V1 val) {
        this.inputList.add(this.copyPair(key, val));
    }

    public void addInput(Pair<K1, V1> input) {
        this.addInput(input.getFirst(), input.getSecond());
    }

    public void addAll(List<Pair<K1, V1>> inputs) {
        for (Pair<K1, V1> input : inputs) {
            this.addInput(input);
        }
    }

    @Deprecated
    public void addInputFromString(String input) {
        this.addInput(MapReduceDriverBase.parseTabbedPair(input));
    }

    private T thisAsMapReduceDriver() {
        return (T)this;
    }

    public T withInput(K1 key, V1 val) {
        this.addInput(key, val);
        return this.thisAsMapReduceDriver();
    }

    public T withInput(Pair<K1, V1> input) {
        this.addInput(input);
        return this.thisAsMapReduceDriver();
    }

    @Deprecated
    public T withInputFromString(String input) {
        this.addInputFromString(input);
        return this.thisAsMapReduceDriver();
    }

    public T withAll(List<Pair<K1, V1>> inputs) {
        this.addAll(inputs);
        return this.thisAsMapReduceDriver();
    }

    public Path getMapInputPath() {
        return this.mapInputPath;
    }

    public void setMapInputPath(Path mapInputPath) {
        this.mapInputPath = mapInputPath;
    }

    public final T withMapInputPath(Path mapInputPath) {
        this.setMapInputPath(mapInputPath);
        return (T)((MapReduceDriverBase)this.thisAsTestDriver());
    }

    protected void preRunChecks(Object mapper, Object reducer) {
        if (this.inputList.isEmpty()) {
            throw new IllegalStateException("No input was provided");
        }
        if (mapper == null) {
            throw new IllegalStateException("No Mapper class was provided");
        }
        if (reducer == null) {
            throw new IllegalStateException("No Reducer class was provided");
        }
        if (this.driverReused()) {
            throw new IllegalStateException("Driver reuse not allowed");
        }
        this.setUsedOnceStatus();
    }

    @Override
    public abstract List<Pair<K3, V3>> run() throws IOException;

    public void setKeyGroupingComparator(RawComparator<K2> groupingComparator) {
        this.keyGroupComparator = (Comparator)ReflectionUtils.newInstance(groupingComparator.getClass(), (Configuration)this.getConfiguration());
    }

    public void setKeyOrderComparator(RawComparator<K2> orderComparator) {
        this.keyValueOrderComparator = (Comparator)ReflectionUtils.newInstance(orderComparator.getClass(), (Configuration)this.getConfiguration());
    }

    public T withKeyGroupingComparator(RawComparator<K2> groupingComparator) {
        this.setKeyGroupingComparator(groupingComparator);
        return this.thisAsMapReduceDriver();
    }

    public T withKeyOrderComparator(RawComparator<K2> orderComparator) {
        this.setKeyOrderComparator(orderComparator);
        return this.thisAsMapReduceDriver();
    }
}

