/*
 * Decompiled with CFR 0.152.
 */
package org.vertexium.query;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.vertexium.VertexiumException;
import org.vertexium.query.Aggregation;
import org.vertexium.query.SupportsNestedAggregationsAggregation;

public class HistogramAggregation
extends Aggregation
implements SupportsNestedAggregationsAggregation {
    private final String aggregationName;
    private final String fieldName;
    private final String interval;
    private final Long minDocumentCount;
    private final List<Aggregation> nestedAggregations = new ArrayList<Aggregation>();
    private ExtendedBounds<?> extendedBounds;

    public HistogramAggregation(String aggregationName, String fieldName, String interval, Long minDocumentCount) {
        this.aggregationName = aggregationName;
        this.fieldName = fieldName;
        this.interval = interval;
        this.minDocumentCount = minDocumentCount;
    }

    @Override
    public String getAggregationName() {
        return this.aggregationName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getInterval() {
        return this.interval;
    }

    public Long getMinDocumentCount() {
        return this.minDocumentCount;
    }

    @Override
    public void addNestedAggregation(Aggregation nestedAggregation) {
        this.nestedAggregations.add(nestedAggregation);
    }

    @Override
    public Iterable<Aggregation> getNestedAggregations() {
        return this.nestedAggregations;
    }

    public ExtendedBounds<?> getExtendedBounds() {
        return this.extendedBounds;
    }

    public void setExtendedBounds(ExtendedBounds<?> extendedBounds) {
        this.extendedBounds = extendedBounds;
    }

    public static class ExtendedBounds<T>
    implements Serializable {
        private static final long serialVersionUID = 6441762717687378245L;
        private final T min;
        private final T max;

        public ExtendedBounds(T min, T max) {
            if (min == null && max == null) {
                throw new VertexiumException("Either min or max needs to not be null");
            }
            this.min = min;
            this.max = max;
        }

        public T getMin() {
            return this.min;
        }

        public T getMax() {
            return this.max;
        }

        public Class<? extends T> getMinMaxType() {
            if (this.min != null) {
                return this.min.getClass();
            }
            if (this.max != null) {
                return this.max.getClass();
            }
            throw new VertexiumException("Invalid state. min or max must not be null.");
        }
    }
}

