/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import java.util.List;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.bulk.AbstractBulkFactory;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.StringUtils;

class UpdateBulkFactory
extends AbstractBulkFactory {
    private final int RETRY_ON_FAILURE;
    private final String RETRY_HEADER;
    private final String SCRIPT;
    private final String SCRIPT_LANG;
    private final boolean HAS_SCRIPT;
    private final boolean HAS_LANG;
    private final boolean HAS_PARAMS;
    private final boolean UPSERT;

    public UpdateBulkFactory(Settings settings) {
        this(settings, false);
    }

    public UpdateBulkFactory(Settings settings, boolean upsert) {
        super(settings);
        this.UPSERT = upsert;
        this.RETRY_ON_FAILURE = settings.getUpdateRetryOnConflict();
        this.RETRY_HEADER = "\"_retry_on_conflict\":" + this.RETRY_ON_FAILURE + "";
        this.HAS_SCRIPT = StringUtils.hasText(settings.getUpdateScript());
        this.HAS_LANG = StringUtils.hasText(settings.getUpdateScriptLang());
        this.HAS_PARAMS = StringUtils.hasText(settings.getUpdateScriptParams());
        this.SCRIPT_LANG = "\"lang\":\"" + settings.getUpdateScriptLang() + "\",";
        this.SCRIPT = "\"script\":\"" + settings.getUpdateScript() + "\"";
    }

    @Override
    protected String getOperation() {
        return "update";
    }

    @Override
    protected void otherHeader(List<Object> pieces) {
        if (this.RETRY_ON_FAILURE > 0) {
            pieces.add(this.RETRY_HEADER);
        }
    }

    @Override
    protected void writeBeforeObject(List<Object> pieces) {
        super.writeBeforeObject(pieces);
        if (!this.settings.hasUpdateScriptParams() && !this.settings.hasUpdateScriptParamsJson()) {
            pieces.add("{");
        }
        if (this.HAS_SCRIPT) {
            if (this.HAS_LANG) {
                pieces.add(this.SCRIPT_LANG);
            }
            pieces.add(this.SCRIPT);
            if (this.UPSERT) {
                pieces.add(",\"upsert\":");
            }
        } else {
            if (this.UPSERT) {
                pieces.add("\"doc_as_upsert\":true,");
            }
            pieces.add("\"doc\":");
        }
    }

    @Override
    protected void writeAfterObject(List<Object> after) {
        after.add("}");
        super.writeAfterObject(after);
    }

    @Override
    protected FieldExtractor id() {
        FieldExtractor id = super.id();
        Assert.notNull(id, String.format("Operation [%s] requires an id but none was given/found", this.getOperation()));
        return id;
    }
}

