/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.client.Attributes;
import org.apache.hadoop.hbase.client.Operation;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.io.WritableUtils;

public abstract class OperationWithAttributes
extends Operation
implements Attributes {
    private Map<String, byte[]> attributes;
    public static String ID_ATRIBUTE = "_operation.attributes.id";

    @Override
    public void setAttribute(String name, byte[] value) {
        if (this.attributes == null && value == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new HashMap<String, byte[]>();
        }
        if (value == null) {
            this.attributes.remove(name);
            if (this.attributes.isEmpty()) {
                this.attributes = null;
            }
        } else {
            this.attributes.put(name, value);
        }
    }

    @Override
    public byte[] getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public Map<String, byte[]> getAttributesMap() {
        if (this.attributes == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.attributes);
    }

    protected long getAttributeSize() {
        long size = 0L;
        if (this.attributes != null) {
            size += (long)ClassSize.align(this.attributes.size() * ClassSize.MAP_ENTRY);
            for (Map.Entry<String, byte[]> entry : this.attributes.entrySet()) {
                size += (long)ClassSize.align(ClassSize.STRING + entry.getKey().length());
                size += (long)ClassSize.align(ClassSize.ARRAY + entry.getValue().length);
            }
        }
        return size;
    }

    protected void writeAttributes(DataOutput out) throws IOException {
        if (this.attributes == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.attributes.size());
            for (Map.Entry<String, byte[]> attr : this.attributes.entrySet()) {
                WritableUtils.writeString((DataOutput)out, (String)attr.getKey());
                Bytes.writeByteArray(out, attr.getValue());
            }
        }
    }

    protected void readAttributes(DataInput in) throws IOException {
        int numAttributes = in.readInt();
        if (numAttributes > 0) {
            this.attributes = new HashMap<String, byte[]>(numAttributes);
            for (int i = 0; i < numAttributes; ++i) {
                String name = WritableUtils.readString((DataInput)in);
                byte[] value = Bytes.readByteArray(in);
                this.attributes.put(name, value);
            }
        }
    }

    public void setId(String id) {
        this.setAttribute(ID_ATRIBUTE, Bytes.toBytes(id));
    }

    public String getId() {
        byte[] attr = this.getAttribute(ID_ATRIBUTE);
        return attr == null ? null : Bytes.toString(attr);
    }
}

