/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HBaseFileSystem;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.regionserver.wal.HLogSplitter;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;

public class SplitLogManager
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(SplitLogManager.class);
    private final Stoppable stopper;
    private final MasterServices master;
    private final String serverName;
    private final TaskFinisher taskFinisher;
    private FileSystem fs;
    private Configuration conf;
    private long zkretries;
    private long resubmit_threshold;
    private long timeout;
    private long unassignedTimeout;
    private long lastNodeCreateTime = Long.MAX_VALUE;
    public boolean ignoreZKDeleteForTesting = false;
    private final ConcurrentMap<String, Task> tasks = new ConcurrentHashMap<String, Task>();
    private TimeoutMonitor timeoutMonitor;
    private Set<String> deadWorkers = null;
    private final Object deadWorkersLock = new Object();
    private Set<String> failedDeletions = null;

    public SplitLogManager(ZooKeeperWatcher zkw, final Configuration conf, Stoppable stopper, MasterServices master, String serverName) {
        this(zkw, conf, stopper, master, serverName, new TaskFinisher(){

            @Override
            public TaskFinisher.Status finish(String workerName, String logfile) {
                try {
                    HLogSplitter.finishSplitLogFile(logfile, conf);
                }
                catch (IOException e) {
                    LOG.warn((Object)("Could not finish splitting of log file " + logfile), (Throwable)e);
                    return TaskFinisher.Status.ERR;
                }
                return TaskFinisher.Status.DONE;
            }
        });
    }

    public SplitLogManager(ZooKeeperWatcher zkw, Configuration conf, Stoppable stopper, MasterServices master, String serverName, TaskFinisher tf) {
        super(zkw);
        this.taskFinisher = tf;
        this.conf = conf;
        this.stopper = stopper;
        this.master = master;
        this.zkretries = conf.getLong("hbase.splitlog.zk.retries", 3L);
        this.resubmit_threshold = conf.getLong("hbase.splitlog.max.resubmit", 3L);
        this.timeout = conf.getInt("hbase.splitlog.manager.timeout", 300000);
        this.unassignedTimeout = conf.getInt("hbase.splitlog.manager.unassigned.timeout", 180000);
        LOG.info((Object)("timeout = " + this.timeout));
        LOG.info((Object)("unassigned timeout = " + this.unassignedTimeout));
        LOG.info((Object)("resubmit threshold = " + this.resubmit_threshold));
        this.serverName = serverName;
        this.timeoutMonitor = new TimeoutMonitor(conf.getInt("hbase.splitlog.manager.timeoutmonitor.period", 1000), stopper);
        this.failedDeletions = Collections.synchronizedSet(new HashSet());
    }

    public void finishInitialization(boolean masterRecovery) {
        if (!masterRecovery) {
            Threads.setDaemonThreadRunning(this.timeoutMonitor.getThread(), this.serverName + ".splitLogManagerTimeoutMonitor");
        }
        if (this.watcher != null) {
            this.watcher.registerListener(this);
            this.lookForOrphans();
        }
    }

    private FileStatus[] getFileList(List<Path> logDirs, PathFilter filter) throws IOException {
        ArrayList<FileStatus> fileStatus = new ArrayList<FileStatus>();
        for (Path hLogDir : logDirs) {
            this.fs = hLogDir.getFileSystem(this.conf);
            if (!this.fs.exists(hLogDir)) {
                LOG.warn((Object)(hLogDir + " doesn't exist. Nothing to do!"));
                continue;
            }
            FileStatus[] logfiles = FSUtils.listStatus(this.fs, hLogDir, filter);
            if (logfiles == null || logfiles.length == 0) {
                LOG.info((Object)(hLogDir + " is empty dir, no logs to split"));
                continue;
            }
            for (FileStatus status : logfiles) {
                fileStatus.add(status);
            }
        }
        FileStatus[] a = new FileStatus[fileStatus.size()];
        return fileStatus.toArray(a);
    }

    public long splitLogDistributed(Path logDir) throws IOException {
        ArrayList<Path> logDirs = new ArrayList<Path>();
        logDirs.add(logDir);
        return this.splitLogDistributed(logDirs);
    }

    public long splitLogDistributed(List<Path> logDirs) throws IOException {
        return this.splitLogDistributed(logDirs, null);
    }

    public long splitLogDistributed(List<Path> logDirs, PathFilter filter) throws IOException {
        String msg;
        MonitoredTask status = TaskMonitor.get().createStatus("Doing distributed log split in " + logDirs);
        FileStatus[] logfiles = this.getFileList(logDirs, filter);
        status.setStatus("Checking directory contents...");
        LOG.debug((Object)"Scheduling batch of logs to split");
        ZKSplitLog.Counters.tot_mgr_log_split_batch_start.incrementAndGet();
        LOG.info((Object)("started splitting logs in " + logDirs));
        long t = EnvironmentEdgeManager.currentTimeMillis();
        long totalSize = 0L;
        TaskBatch batch = new TaskBatch();
        for (FileStatus lf : logfiles) {
            totalSize += lf.getLen();
            if (this.enqueueSplitTask(lf.getPath().toString(), batch)) continue;
            throw new IOException("duplicate log split scheduled for " + lf.getPath());
        }
        this.waitForSplittingCompletion(batch, status);
        if (batch.done != batch.installed) {
            batch.isDead = true;
            ZKSplitLog.Counters.tot_mgr_log_split_batch_err.incrementAndGet();
            LOG.warn((Object)("error while splitting logs in " + logDirs + " installed = " + batch.installed + " but only " + batch.done + " done"));
            msg = "error or interrupted while splitting logs in " + logDirs + " Task = " + batch;
            status.abort(msg);
            throw new IOException(msg);
        }
        for (Path logDir : logDirs) {
            status.setStatus("Cleaning up log directory...");
            try {
                if (this.fs.exists(logDir) && !HBaseFileSystem.deleteFileFromFileSystem(this.fs, logDir)) {
                    LOG.warn((Object)("Unable to delete log src dir. Ignoring. " + logDir));
                }
            }
            catch (IOException ioe) {
                FileStatus[] files = this.fs.listStatus(logDir);
                if (files != null && files.length > 0) {
                    LOG.warn((Object)("returning success without actually splitting and deleting all the log files in path " + logDir));
                }
                LOG.warn((Object)("Unable to delete log src dir. Ignoring. " + logDir), (Throwable)ioe);
            }
            ZKSplitLog.Counters.tot_mgr_log_split_batch_success.incrementAndGet();
        }
        msg = "finished splitting (more than or equal to) " + totalSize + " bytes in " + batch.installed + " log files in " + logDirs + " in " + (EnvironmentEdgeManager.currentTimeMillis() - t) + "ms";
        status.markComplete(msg);
        LOG.info((Object)msg);
        return totalSize;
    }

    boolean enqueueSplitTask(String taskname, TaskBatch batch) {
        ZKSplitLog.Counters.tot_mgr_log_split_start.incrementAndGet();
        String path = ZKSplitLog.getEncodedNodeName(this.watcher, taskname);
        Task oldtask = this.createTaskIfAbsent(path, batch);
        if (oldtask == null) {
            this.createNode(path, this.zkretries);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSplittingCompletion(TaskBatch batch, MonitoredTask status) {
        TaskBatch taskBatch = batch;
        synchronized (taskBatch) {
            while (batch.done + batch.error != batch.installed) {
                try {
                    int remainingInZK;
                    status.setStatus("Waiting for distributed tasks to finish.  scheduled=" + batch.installed + " done=" + batch.done + " error=" + batch.error);
                    int remaining = batch.installed - (batch.done + batch.error);
                    int actual = this.activeTasks(batch);
                    if (remaining != actual) {
                        LOG.warn((Object)("Expected " + remaining + " active tasks, but actually there are " + actual));
                    }
                    if ((remainingInZK = this.remainingTasksInZK()) >= 0 && actual > remainingInZK) {
                        LOG.warn((Object)("Expected at least" + actual + " tasks in ZK, but actually there are " + remainingInZK));
                    }
                    if (remainingInZK == 0 || actual == 0) {
                        LOG.warn((Object)("No more task remaining (ZK or task map), splitting should have completed. Remaining tasks in ZK " + remainingInZK + ", active tasks in map " + actual));
                        if (remainingInZK == 0 && actual == 0) {
                            return;
                        }
                    }
                    batch.wait(100L);
                    if (!this.stopper.isStopped()) continue;
                    LOG.warn((Object)"Stopped while waiting for log splits to be completed");
                    return;
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Interrupted while waiting for log splits to be completed");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    private int activeTasks(TaskBatch batch) {
        int count = 0;
        for (Task t : this.tasks.values()) {
            if (t.batch != batch || t.status != TerminationStatus.IN_PROGRESS) continue;
            ++count;
        }
        return count;
    }

    private int remainingTasksInZK() {
        int count = 0;
        try {
            List<String> tasks = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.splitLogZNode);
            if (tasks != null) {
                for (String t : tasks) {
                    if (ZKSplitLog.isRescanNode(this.watcher, t)) continue;
                    ++count;
                }
            }
        }
        catch (KeeperException ke) {
            LOG.warn((Object)"Failed to check remaining tasks", (Throwable)ke);
            count = -1;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDone(String path, TerminationStatus status) {
        Task task = (Task)this.tasks.get(path);
        if (task == null) {
            if (!ZKSplitLog.isRescanNode(this.watcher, path)) {
                ZKSplitLog.Counters.tot_mgr_unacquired_orphan_done.incrementAndGet();
                LOG.debug((Object)("unacquired orphan task is done " + path));
            }
        } else {
            Task task2 = task;
            synchronized (task2) {
                if (task.status == TerminationStatus.IN_PROGRESS) {
                    if (status == TerminationStatus.SUCCESS) {
                        ZKSplitLog.Counters.tot_mgr_log_split_success.incrementAndGet();
                        LOG.info((Object)("Done splitting " + path));
                    } else {
                        ZKSplitLog.Counters.tot_mgr_log_split_err.incrementAndGet();
                        LOG.warn((Object)("Error splitting " + path));
                    }
                    task.status = status;
                    if (task.batch != null) {
                        TaskBatch taskBatch = task.batch;
                        synchronized (taskBatch) {
                            if (status == TerminationStatus.SUCCESS) {
                                ++task.batch.done;
                            } else {
                                ++task.batch.error;
                            }
                            task.batch.notify();
                        }
                    }
                }
            }
        }
        this.deleteNode(path, this.zkretries);
    }

    private void createNode(String path, Long retry_count) {
        ZKUtil.asyncCreate(this.watcher, path, ZKSplitLog.TaskState.TASK_UNASSIGNED.get(this.serverName), new CreateAsyncCallback(), retry_count);
        ZKSplitLog.Counters.tot_mgr_node_create_queued.incrementAndGet();
    }

    private void createNodeSuccess(String path) {
        this.lastNodeCreateTime = EnvironmentEdgeManager.currentTimeMillis();
        LOG.debug((Object)("put up splitlog task at znode " + path));
        this.getDataSetWatch(path, this.zkretries);
    }

    private void createNodeFailure(String path) {
        LOG.warn((Object)("failed to create task node" + path));
        this.setDone(path, TerminationStatus.FAILURE);
    }

    private void getDataSetWatch(String path, Long retry_count) {
        this.watcher.getRecoverableZooKeeper().getZooKeeper().getData(path, (Watcher)this.watcher, (AsyncCallback.DataCallback)new GetDataAsyncCallback(), (Object)retry_count);
        ZKSplitLog.Counters.tot_mgr_get_data_queued.incrementAndGet();
    }

    private void tryGetDataSetWatch(String path) {
        this.watcher.getRecoverableZooKeeper().getZooKeeper().getData(path, (Watcher)this.watcher, (AsyncCallback.DataCallback)new GetDataAsyncCallback(), (Object)new Long(-1L));
        ZKSplitLog.Counters.tot_mgr_get_data_queued.incrementAndGet();
    }

    private void getDataSetWatchSuccess(String path, byte[] data, int version) {
        if (data == null) {
            if (version == Integer.MIN_VALUE) {
                this.setDone(path, TerminationStatus.SUCCESS);
                return;
            }
            ZKSplitLog.Counters.tot_mgr_null_data.incrementAndGet();
            LOG.fatal((Object)("logic error - got null data " + path));
            this.setDone(path, TerminationStatus.FAILURE);
            return;
        }
        data = this.watcher.getRecoverableZooKeeper().removeMetaData(data);
        if (ZKSplitLog.TaskState.TASK_UNASSIGNED.equals(data)) {
            LOG.debug((Object)("task not yet acquired " + path + " ver = " + version));
            this.handleUnassignedTask(path);
        } else if (ZKSplitLog.TaskState.TASK_OWNED.equals(data)) {
            this.heartbeat(path, version, ZKSplitLog.TaskState.TASK_OWNED.getWriterName(data));
        } else if (ZKSplitLog.TaskState.TASK_RESIGNED.equals(data)) {
            LOG.info((Object)("task " + path + " entered state " + new String(data)));
            this.resubmitOrFail(path, ResubmitDirective.FORCE);
        } else if (ZKSplitLog.TaskState.TASK_DONE.equals(data)) {
            LOG.info((Object)("task " + path + " entered state " + new String(data)));
            if (this.taskFinisher != null && !ZKSplitLog.isRescanNode(this.watcher, path)) {
                if (this.taskFinisher.finish(ZKSplitLog.TaskState.TASK_DONE.getWriterName(data), ZKSplitLog.getFileName(path)) == TaskFinisher.Status.DONE) {
                    this.setDone(path, TerminationStatus.SUCCESS);
                } else {
                    this.resubmitOrFail(path, ResubmitDirective.CHECK);
                }
            } else {
                this.setDone(path, TerminationStatus.SUCCESS);
            }
        } else if (ZKSplitLog.TaskState.TASK_ERR.equals(data)) {
            LOG.info((Object)("task " + path + " entered state " + new String(data)));
            this.resubmitOrFail(path, ResubmitDirective.CHECK);
        } else {
            LOG.fatal((Object)("logic error - unexpected zk state for path = " + path + " data = " + new String(data)));
            this.setDone(path, TerminationStatus.FAILURE);
        }
    }

    private void getDataSetWatchFailure(String path) {
        LOG.warn((Object)("failed to set data watch " + path));
        this.setDone(path, TerminationStatus.FAILURE);
    }

    private void handleUnassignedTask(String path) {
        if (ZKSplitLog.isRescanNode(this.watcher, path)) {
            return;
        }
        Task task = this.findOrCreateOrphanTask(path);
        if (task.isOrphan() && task.incarnation == 0) {
            LOG.info((Object)("resubmitting unassigned orphan task " + path));
            this.resubmit(path, task, ResubmitDirective.FORCE);
        }
    }

    private boolean shouldAbandonRetries(int statusCode, String action) {
        if (statusCode == KeeperException.Code.SESSIONEXPIRED.intValue()) {
            LOG.error((Object)("ZK session expired. Master is expected to shut down. Abandoning retries for action=" + action));
            return true;
        }
        return false;
    }

    private void heartbeat(String path, int new_version, String workerName) {
        Task task = this.findOrCreateOrphanTask(path);
        if (new_version != task.last_version) {
            if (task.isUnassigned()) {
                LOG.info((Object)("task " + path + " acquired by " + workerName));
            }
            task.heartbeat(EnvironmentEdgeManager.currentTimeMillis(), new_version, workerName);
            ZKSplitLog.Counters.tot_mgr_heartbeat.incrementAndGet();
        }
    }

    private boolean resubmit(String path, Task task, ResubmitDirective directive) {
        int version;
        if (task.status != TerminationStatus.IN_PROGRESS) {
            return false;
        }
        if (directive != ResubmitDirective.FORCE) {
            boolean alive;
            long time = EnvironmentEdgeManager.currentTimeMillis() - task.last_update;
            ServerName curWorker = null;
            if (!Strings.isNullOrEmpty((String)task.cur_worker_name)) {
                try {
                    curWorker = ServerName.parseServerName(task.cur_worker_name);
                }
                catch (IllegalArgumentException ie) {
                    LOG.error((Object)("Got invalid server name:" + task.cur_worker_name + " - task for path:" + path + " won't be resubmitted before timeout"));
                }
            } else {
                LOG.error((Object)("Got empty/null server name:" + task.cur_worker_name + " - task for path:" + path + " won't be resubmitted before timeout"));
            }
            boolean bl = alive = this.master.getServerManager() != null && curWorker != null ? this.master.getServerManager().isServerOnline(curWorker) : true;
            if (alive && time < this.timeout) {
                LOG.trace((Object)("Skipping the resubmit of " + task.toString() + "  because the server " + task.cur_worker_name + " is not marked as dead, we waited for " + time + " while the timeout is " + this.timeout));
                return false;
            }
            if ((long)task.unforcedResubmits >= this.resubmit_threshold) {
                if (!task.resubmitThresholdReached) {
                    task.resubmitThresholdReached = true;
                    ZKSplitLog.Counters.tot_mgr_resubmit_threshold_reached.incrementAndGet();
                    LOG.info((Object)("Skipping resubmissions of task " + path + " because threshold " + this.resubmit_threshold + " reached"));
                }
                return false;
            }
            version = task.last_version;
        } else {
            version = -1;
        }
        LOG.info((Object)("resubmitting task " + path));
        ++task.incarnation;
        try {
            if (!ZKUtil.setData(this.watcher, path, ZKSplitLog.TaskState.TASK_UNASSIGNED.get(this.serverName), version)) {
                LOG.debug((Object)("failed to resubmit task " + path + " version changed"));
                task.heartbeatNoDetails(EnvironmentEdgeManager.currentTimeMillis());
                return false;
            }
        }
        catch (KeeperException.NoNodeException e) {
            LOG.warn((Object)("failed to resubmit because znode doesn't exist " + path + " task done (or forced done by removing the znode)"));
            this.getDataSetWatchSuccess(path, null, Integer.MIN_VALUE);
            return false;
        }
        catch (KeeperException.BadVersionException e) {
            LOG.debug((Object)("failed to resubmit task " + path + " version changed"));
            task.heartbeatNoDetails(EnvironmentEdgeManager.currentTimeMillis());
            return false;
        }
        catch (KeeperException e) {
            ZKSplitLog.Counters.tot_mgr_resubmit_failed.incrementAndGet();
            LOG.warn((Object)("failed to resubmit " + path), (Throwable)e);
            return false;
        }
        if (directive != ResubmitDirective.FORCE) {
            ++task.unforcedResubmits;
        }
        task.setUnassigned();
        this.createRescanNode(Long.MAX_VALUE);
        ZKSplitLog.Counters.tot_mgr_resubmit.incrementAndGet();
        return true;
    }

    private void resubmitOrFail(String path, ResubmitDirective directive) {
        if (!this.resubmit(path, this.findOrCreateOrphanTask(path), directive)) {
            this.setDone(path, TerminationStatus.FAILURE);
        }
    }

    private void deleteNode(String path, Long retries) {
        ZKSplitLog.Counters.tot_mgr_node_delete_queued.incrementAndGet();
        this.watcher.getRecoverableZooKeeper().getZooKeeper().delete(path, -1, (AsyncCallback.VoidCallback)new DeleteAsyncCallback(), (Object)retries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteNodeSuccess(String path) {
        if (this.ignoreZKDeleteForTesting) {
            return;
        }
        Task task = (Task)this.tasks.remove(path);
        if (task == null) {
            if (ZKSplitLog.isRescanNode(this.watcher, path)) {
                ZKSplitLog.Counters.tot_mgr_rescan_deleted.incrementAndGet();
            }
            ZKSplitLog.Counters.tot_mgr_missing_state_in_delete.incrementAndGet();
            LOG.debug((Object)("deleted task without in memory state " + path));
            return;
        }
        Task task2 = task;
        synchronized (task2) {
            task.status = TerminationStatus.DELETED;
            task.notify();
        }
        ZKSplitLog.Counters.tot_mgr_task_deleted.incrementAndGet();
    }

    private void deleteNodeFailure(String path) {
        LOG.info((Object)("Failed to delete node " + path + " and will retry soon."));
    }

    private void createRescanNode(long retries) {
        this.watcher.getRecoverableZooKeeper().getZooKeeper().create(ZKSplitLog.getRescanNode(this.watcher), ZKSplitLog.TaskState.TASK_DONE.get(this.serverName), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL, (AsyncCallback.StringCallback)new CreateRescanAsyncCallback(), (Object)retries);
    }

    private void createRescanSuccess(String path) {
        this.lastNodeCreateTime = EnvironmentEdgeManager.currentTimeMillis();
        ZKSplitLog.Counters.tot_mgr_rescan.incrementAndGet();
        this.getDataSetWatch(path, this.zkretries);
    }

    private void createRescanFailure() {
        LOG.fatal((Object)"logic failure, rescan failure must not happen");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task createTaskIfAbsent(String path, TaskBatch batch) {
        Task newtask = new Task();
        newtask.batch = batch;
        Task oldtask = this.tasks.putIfAbsent(path, newtask);
        if (oldtask == null) {
            ++batch.installed;
            return null;
        }
        Task task = oldtask;
        synchronized (task) {
            if (oldtask.isOrphan()) {
                if (oldtask.status == TerminationStatus.SUCCESS) {
                    return null;
                }
                if (oldtask.status == TerminationStatus.IN_PROGRESS) {
                    oldtask.batch = batch;
                    ++batch.installed;
                    LOG.debug((Object)("Previously orphan task " + path + " is now being waited upon"));
                    return null;
                }
                while (oldtask.status == TerminationStatus.FAILURE) {
                    LOG.debug((Object)("wait for status of task " + path + " to change to DELETED"));
                    ZKSplitLog.Counters.tot_mgr_wait_for_zk_delete.incrementAndGet();
                    try {
                        oldtask.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOG.warn((Object)"Interrupted when waiting for znode delete callback");
                        break;
                    }
                }
                if (oldtask.status != TerminationStatus.DELETED) {
                    LOG.warn((Object)("Failure because previously failed task state still present. Waiting for znode delete callback path=" + path));
                    return oldtask;
                }
                Task t = this.tasks.putIfAbsent(path, newtask);
                if (t == null) {
                    ++batch.installed;
                    return null;
                }
                LOG.fatal((Object)"Logic error. Deleted task still present in tasks map");
                assert (false) : "Deleted task still present in tasks map";
                return t;
            }
            LOG.warn((Object)("Failure because two threads can't wait for the same task.  path=" + path));
            return oldtask;
        }
    }

    Task findOrCreateOrphanTask(String path) {
        Task orphanTask = new Task();
        Task task = this.tasks.putIfAbsent(path, orphanTask);
        if (task == null) {
            LOG.info((Object)("creating orphan task " + path));
            ZKSplitLog.Counters.tot_mgr_orphan_task_acquired.incrementAndGet();
            task = orphanTask;
        }
        return task;
    }

    @Override
    public void nodeDataChanged(String path) {
        Task task = (Task)this.tasks.get(path);
        if (task != null || ZKSplitLog.isRescanNode(this.watcher, path)) {
            if (task != null) {
                task.heartbeatNoDetails(EnvironmentEdgeManager.currentTimeMillis());
            }
            this.getDataSetWatch(path, this.zkretries);
        }
    }

    public void stop() {
        if (this.timeoutMonitor != null) {
            this.timeoutMonitor.interrupt();
        }
    }

    private void lookForOrphans() {
        List<String> orphans;
        try {
            orphans = ZKUtil.listChildrenNoWatch(this.watcher, this.watcher.splitLogZNode);
            if (orphans == null) {
                LOG.warn((Object)("could not get children of " + this.watcher.splitLogZNode));
                return;
            }
        }
        catch (KeeperException e) {
            LOG.warn((Object)("could not get children of " + this.watcher.splitLogZNode + " " + StringUtils.stringifyException((Throwable)e)));
            return;
        }
        int rescan_nodes = 0;
        for (String path : orphans) {
            String nodepath = ZKUtil.joinZNode(this.watcher.splitLogZNode, path);
            if (ZKSplitLog.isRescanNode(this.watcher, nodepath)) {
                ++rescan_nodes;
                LOG.debug((Object)("found orphan rescan node " + path));
            } else {
                LOG.info((Object)("found orphan task " + path));
            }
            this.getDataSetWatch(nodepath, this.zkretries);
        }
        LOG.info((Object)("found " + (orphans.size() - rescan_nodes) + " orphan tasks and " + rescan_nodes + " rescan nodes"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDeadWorker(String workerName) {
        Object object = this.deadWorkersLock;
        synchronized (object) {
            if (this.deadWorkers == null) {
                this.deadWorkers = new HashSet<String>(100);
            }
            this.deadWorkers.add(workerName);
        }
        LOG.info((Object)("dead splitlog worker " + workerName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDeadWorkers(List<ServerName> serverNames) {
        ArrayList<String> workerNames = new ArrayList<String>(serverNames.size());
        for (ServerName serverName : serverNames) {
            workerNames.add(serverName.toString());
        }
        Object object = this.deadWorkersLock;
        synchronized (object) {
            if (this.deadWorkers == null) {
                this.deadWorkers = new HashSet<String>(100);
            }
            this.deadWorkers.addAll(workerNames);
        }
        LOG.info((Object)("dead splitlog workers " + workerNames));
    }

    public void finishInitialization() {
        this.finishInitialization(false);
    }

    static enum TerminationStatus {
        IN_PROGRESS("in_progress"),
        SUCCESS("success"),
        FAILURE("failure"),
        DELETED("deleted");

        String statusMsg;

        private TerminationStatus(String msg) {
            this.statusMsg = msg;
        }

        public String toString() {
            return this.statusMsg;
        }
    }

    static enum ResubmitDirective {
        CHECK,
        FORCE;

    }

    public static interface TaskFinisher {
        public Status finish(String var1, String var2);

        public static enum Status {
            DONE,
            ERR;

        }
    }

    class CreateRescanAsyncCallback
    implements AsyncCallback.StringCallback {
        private final Log LOG = LogFactory.getLog(CreateRescanAsyncCallback.class);

        CreateRescanAsyncCallback() {
        }

        public void processResult(int rc, String path, Object ctx, String name) {
            if (rc != 0) {
                if (SplitLogManager.this.shouldAbandonRetries(rc, "CreateRescan znode " + path)) {
                    return;
                }
                Long retry_count = (Long)ctx;
                this.LOG.warn((Object)("rc=" + KeeperException.Code.get((int)rc) + " for " + path + " remaining retries=" + retry_count));
                if (retry_count == 0L) {
                    SplitLogManager.this.createRescanFailure();
                } else {
                    SplitLogManager.this.createRescanNode(retry_count - 1L);
                }
                return;
            }
            SplitLogManager.this.createRescanSuccess(name);
        }
    }

    class DeleteAsyncCallback
    implements AsyncCallback.VoidCallback {
        private final Log LOG = LogFactory.getLog(DeleteAsyncCallback.class);

        DeleteAsyncCallback() {
        }

        public void processResult(int rc, String path, Object ctx) {
            ZKSplitLog.Counters.tot_mgr_node_delete_result.incrementAndGet();
            if (rc != 0) {
                if (SplitLogManager.this.shouldAbandonRetries(rc, "Delete znode " + path)) {
                    SplitLogManager.this.failedDeletions.add(path);
                    return;
                }
                if (rc != KeeperException.Code.NONODE.intValue()) {
                    ZKSplitLog.Counters.tot_mgr_node_delete_err.incrementAndGet();
                    Long retry_count = (Long)ctx;
                    this.LOG.warn((Object)("delete rc=" + KeeperException.Code.get((int)rc) + " for " + path + " remaining retries=" + retry_count));
                    if (retry_count == 0L) {
                        this.LOG.warn((Object)("delete failed " + path));
                        SplitLogManager.this.failedDeletions.add(path);
                        SplitLogManager.this.deleteNodeFailure(path);
                    } else {
                        SplitLogManager.this.deleteNode(path, retry_count - 1L);
                    }
                    return;
                }
                this.LOG.debug((Object)(path + " does not exist. Either was created but deleted behind our" + " back by another pending delete OR was deleted" + " in earlier retry rounds. zkretries = " + (Long)ctx));
            } else {
                this.LOG.debug((Object)("deleted " + path));
            }
            SplitLogManager.this.deleteNodeSuccess(path);
        }
    }

    class GetDataAsyncCallback
    implements AsyncCallback.DataCallback {
        private final Log LOG = LogFactory.getLog(GetDataAsyncCallback.class);

        GetDataAsyncCallback() {
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            ZKSplitLog.Counters.tot_mgr_get_data_result.incrementAndGet();
            if (rc != 0) {
                if (SplitLogManager.this.shouldAbandonRetries(rc, "GetData from znode " + path)) {
                    return;
                }
                if (rc == KeeperException.Code.NONODE.intValue()) {
                    ZKSplitLog.Counters.tot_mgr_get_data_nonode.incrementAndGet();
                    this.LOG.warn((Object)("task znode " + path + " vanished."));
                    SplitLogManager.this.getDataSetWatchSuccess(path, null, Integer.MIN_VALUE);
                    return;
                }
                Long retry_count = (Long)ctx;
                if (retry_count < 0L) {
                    this.LOG.warn((Object)("getdata rc = " + KeeperException.Code.get((int)rc) + " " + path + ". Ignoring error. No error handling. No retrying."));
                    return;
                }
                this.LOG.warn((Object)("getdata rc = " + KeeperException.Code.get((int)rc) + " " + path + " remaining retries=" + retry_count));
                if (retry_count == 0L) {
                    ZKSplitLog.Counters.tot_mgr_get_data_err.incrementAndGet();
                    SplitLogManager.this.getDataSetWatchFailure(path);
                } else {
                    ZKSplitLog.Counters.tot_mgr_get_data_retry.incrementAndGet();
                    SplitLogManager.this.getDataSetWatch(path, retry_count - 1L);
                }
                return;
            }
            SplitLogManager.this.getDataSetWatchSuccess(path, data, stat.getVersion());
        }
    }

    class CreateAsyncCallback
    implements AsyncCallback.StringCallback {
        private final Log LOG = LogFactory.getLog(CreateAsyncCallback.class);

        CreateAsyncCallback() {
        }

        public void processResult(int rc, String path, Object ctx, String name) {
            ZKSplitLog.Counters.tot_mgr_node_create_result.incrementAndGet();
            if (rc != 0) {
                if (SplitLogManager.this.shouldAbandonRetries(rc, "Create znode " + path)) {
                    SplitLogManager.this.createNodeFailure(path);
                    return;
                }
                if (rc == KeeperException.Code.NODEEXISTS.intValue()) {
                    this.LOG.debug((Object)("found pre-existing znode " + path));
                    ZKSplitLog.Counters.tot_mgr_node_already_exists.incrementAndGet();
                } else {
                    Long retry_count = (Long)ctx;
                    this.LOG.warn((Object)("create rc =" + KeeperException.Code.get((int)rc) + " for " + path + " remaining retries=" + retry_count));
                    if (retry_count == 0L) {
                        ZKSplitLog.Counters.tot_mgr_node_create_err.incrementAndGet();
                        SplitLogManager.this.createNodeFailure(path);
                    } else {
                        ZKSplitLog.Counters.tot_mgr_node_create_retry.incrementAndGet();
                        SplitLogManager.this.createNode(path, retry_count - 1L);
                    }
                    return;
                }
            }
            SplitLogManager.this.createNodeSuccess(path);
        }
    }

    private class TimeoutMonitor
    extends Chore {
        public TimeoutMonitor(int period, Stoppable stopper) {
            super("SplitLogManager Timeout Monitor", period, stopper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void chore() {
            Task task;
            String path;
            Set localDeadWorkers;
            int resubmitted = 0;
            int unassigned = 0;
            int tot = 0;
            boolean found_assigned_task = false;
            Object object = SplitLogManager.this.deadWorkersLock;
            synchronized (object) {
                localDeadWorkers = SplitLogManager.this.deadWorkers;
                SplitLogManager.this.deadWorkers = null;
            }
            for (Map.Entry e : SplitLogManager.this.tasks.entrySet()) {
                path = (String)e.getKey();
                task = (Task)e.getValue();
                String cur_worker = task.cur_worker_name;
                ++tot;
                if (task.isUnassigned()) {
                    ++unassigned;
                    continue;
                }
                found_assigned_task = true;
                if (localDeadWorkers != null && localDeadWorkers.contains(cur_worker)) {
                    ZKSplitLog.Counters.tot_mgr_resubmit_dead_server_task.incrementAndGet();
                    if (SplitLogManager.this.resubmit(path, task, ResubmitDirective.FORCE)) {
                        ++resubmitted;
                        continue;
                    }
                    SplitLogManager.this.handleDeadWorker(cur_worker);
                    LOG.warn((Object)("Failed to resubmit task " + path + " owned by dead " + cur_worker + ", will retry."));
                    continue;
                }
                if (!SplitLogManager.this.resubmit(path, task, ResubmitDirective.CHECK)) continue;
                ++resubmitted;
            }
            if (tot > 0) {
                LOG.debug((Object)("total tasks = " + tot + " unassigned = " + unassigned));
            }
            if (resubmitted > 0) {
                LOG.info((Object)("resubmitted " + resubmitted + " out of " + tot + " tasks"));
            }
            if (tot > 0 && !found_assigned_task && EnvironmentEdgeManager.currentTimeMillis() - SplitLogManager.this.lastNodeCreateTime > SplitLogManager.this.unassignedTimeout) {
                for (Map.Entry e : SplitLogManager.this.tasks.entrySet()) {
                    path = (String)e.getKey();
                    task = (Task)e.getValue();
                    if (!task.isUnassigned() || task.status == TerminationStatus.FAILURE) continue;
                    SplitLogManager.this.tryGetDataSetWatch(path);
                }
                SplitLogManager.this.createRescanNode(Long.MAX_VALUE);
                ZKSplitLog.Counters.tot_mgr_resubmit_unassigned.incrementAndGet();
                LOG.debug((Object)"resubmitting unassigned task(s) after timeout");
            }
            if (SplitLogManager.this.failedDeletions.size() > 0) {
                ArrayList tmpPaths = new ArrayList(SplitLogManager.this.failedDeletions);
                SplitLogManager.this.failedDeletions.removeAll(tmpPaths);
                for (String tmpPath : tmpPaths) {
                    SplitLogManager.this.deleteNode(tmpPath, SplitLogManager.this.zkretries);
                }
            }
        }
    }

    static class Task {
        volatile long last_update;
        volatile int last_version = -1;
        volatile String cur_worker_name;
        TaskBatch batch;
        volatile TerminationStatus status = TerminationStatus.IN_PROGRESS;
        volatile int incarnation = 0;
        volatile int unforcedResubmits;
        volatile boolean resubmitThresholdReached;

        public String toString() {
            return "last_update = " + this.last_update + " last_version = " + this.last_version + " cur_worker_name = " + this.cur_worker_name + " status = " + (Object)((Object)this.status) + " incarnation = " + this.incarnation + " resubmits = " + this.unforcedResubmits + " batch = " + this.batch;
        }

        Task() {
            this.setUnassigned();
        }

        public boolean isOrphan() {
            return this.batch == null || this.batch.isDead;
        }

        public boolean isUnassigned() {
            return this.cur_worker_name == null;
        }

        public void heartbeatNoDetails(long time) {
            this.last_update = time;
        }

        public void heartbeat(long time, int version, String worker) {
            this.last_version = version;
            this.last_update = time;
            this.cur_worker_name = worker;
        }

        public void setUnassigned() {
            this.cur_worker_name = null;
            this.last_update = -1L;
        }
    }

    static class TaskBatch {
        int installed = 0;
        int done = 0;
        int error = 0;
        volatile boolean isDead = false;

        TaskBatch() {
        }

        public String toString() {
            return "installed = " + this.installed + " done = " + this.done + " error = " + this.error;
        }
    }
}

