/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.zip.Checksum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.util.ChecksumFactory;

public enum ChecksumType {
    NULL(0){

        @Override
        public String getName() {
            return "NULL";
        }

        @Override
        public void initialize() {
        }

        @Override
        public Checksum getChecksumObject() throws IOException {
            return null;
        }
    }
    ,
    CRC32(1){
        private volatile Constructor<?> ctor;

        @Override
        public String getName() {
            return "CRC32";
        }

        @Override
        public void initialize() {
            String PURECRC32 = "org.apache.hadoop.util.PureJavaCrc32";
            String JDKCRC = "java.util.zip.CRC32";
            this.LOG = LogFactory.getLog(ChecksumType.class);
            try {
                this.ctor = ChecksumFactory.newConstructor("org.apache.hadoop.util.PureJavaCrc32");
                this.LOG.info((Object)"Checksum using org.apache.hadoop.util.PureJavaCrc32");
            }
            catch (Exception e) {
                this.LOG.trace((Object)"org.apache.hadoop.util.PureJavaCrc32 not available.");
            }
            try {
                if (this.ctor == null) {
                    this.ctor = ChecksumFactory.newConstructor("java.util.zip.CRC32");
                    this.LOG.info((Object)"Checksum can use java.util.zip.CRC32");
                }
            }
            catch (Exception e) {
                this.LOG.trace((Object)"java.util.zip.CRC32 not available.");
            }
        }

        @Override
        public Checksum getChecksumObject() throws IOException {
            if (this.ctor == null) {
                throw new IOException("Bad constructor for " + this.getName());
            }
            try {
                return (Checksum)this.ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }
    ,
    CRC32C(2){
        private transient Constructor<?> ctor;

        @Override
        public String getName() {
            return "CRC32C";
        }

        @Override
        public void initialize() {
            String PURECRC32C = "org.apache.hadoop.util.PureJavaCrc32C";
            this.LOG = LogFactory.getLog(ChecksumType.class);
            try {
                this.ctor = ChecksumFactory.newConstructor("org.apache.hadoop.util.PureJavaCrc32C");
                this.LOG.info((Object)"Checksum can use org.apache.hadoop.util.PureJavaCrc32C");
            }
            catch (Exception e) {
                this.LOG.trace((Object)"org.apache.hadoop.util.PureJavaCrc32C not available.");
            }
        }

        @Override
        public Checksum getChecksumObject() throws IOException {
            if (this.ctor == null) {
                throw new IOException("Bad constructor for " + this.getName());
            }
            try {
                return (Checksum)this.ctor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    };

    private final byte code;
    protected Log LOG;

    abstract void initialize();

    public abstract String getName();

    private ChecksumType(byte c) {
        this.code = c;
        this.initialize();
    }

    public abstract Checksum getChecksumObject() throws IOException;

    public byte getCode() {
        return this.code;
    }

    public static ChecksumType codeToType(byte b) {
        for (ChecksumType t : ChecksumType.values()) {
            if (t.getCode() != b) continue;
            return t;
        }
        throw new RuntimeException("Unknown checksum type code " + b);
    }

    public static ChecksumType nameToType(String name) {
        for (ChecksumType t : ChecksumType.values()) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        throw new RuntimeException("Unknown checksum type name " + name);
    }
}

