/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class SoftValueSortedMap<K, V>
implements SortedMap<K, V> {
    private final SortedMap<K, SoftValue<K, V>> internalMap;
    private final ReferenceQueue<V> rq = new ReferenceQueue();
    private Object sync;

    public SoftValueSortedMap() {
        this(new TreeMap());
    }

    public SoftValueSortedMap(Comparator<K> c) {
        this(new TreeMap(c));
    }

    private SoftValueSortedMap(SortedMap<K, SoftValue<K, V>> original) {
        this(original, original);
    }

    private SoftValueSortedMap(SortedMap<K, SoftValue<K, V>> original, Object sync) {
        this.internalMap = original;
        this.sync = sync;
    }

    private int checkReferences() {
        Reference<V> ref;
        int i = 0;
        while ((ref = this.rq.poll()) != null) {
            ++i;
            this.internalMap.remove(((SoftValue)ref).key);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            SoftValue<K, V> oldValue = this.internalMap.put(key, new SoftValue<K, V>(key, value, this.rq));
            return oldValue == null ? null : (V)oldValue.get();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new RuntimeException("Not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            SoftValue value = (SoftValue)this.internalMap.get(key);
            if (value == null) {
                return null;
            }
            if (value.get() == null) {
                this.internalMap.remove(key);
                return null;
            }
            return (V)value.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            SoftValue value = (SoftValue)this.internalMap.remove(key);
            return value == null ? null : (V)value.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            return this.internalMap.containsKey(key);
        }
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Don't support containsValue!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K firstKey() {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            return this.internalMap.firstKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K lastKey() {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            return this.internalMap.lastKey();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SoftValueSortedMap<K, V> headMap(K key) {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            return new SoftValueSortedMap<K, V>(this.internalMap.headMap(key), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SoftValueSortedMap<K, V> tailMap(K key) {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            return new SoftValueSortedMap<K, V>(this.internalMap.tailMap(key), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SoftValueSortedMap<K, V> subMap(K fromKey, K toKey) {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            return new SoftValueSortedMap<K, V>(this.internalMap.subMap(fromKey, toKey), this.sync);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized V lowerValueByKey(K key) {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            Map.Entry entry = ((NavigableMap)this.internalMap).lowerEntry(key);
            if (entry == null) {
                return null;
            }
            SoftValue value = (SoftValue)entry.getValue();
            if (value == null) {
                return null;
            }
            if (value.get() == null) {
                this.internalMap.remove(key);
                return null;
            }
            return (V)value.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            return this.internalMap.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            return this.internalMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            this.internalMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            return Collections.unmodifiableSet(this.internalMap.keySet());
        }
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.internalMap.comparator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            LinkedHashSet<Map.Entry<K, V>> realEntries = new LinkedHashSet<Map.Entry<K, V>>();
            for (Map.Entry<K, SoftValue<K, V>> entry : this.internalMap.entrySet()) {
                realEntries.add(entry.getValue());
            }
            return realEntries;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        Object object = this.sync;
        synchronized (object) {
            this.checkReferences();
            ArrayList hardValues = new ArrayList();
            for (SoftValue<K, V> softValue : this.internalMap.values()) {
                hardValues.add(softValue.get());
            }
            return hardValues;
        }
    }

    private static class SoftValue<K, V>
    extends SoftReference<V>
    implements Map.Entry<K, V> {
        final K key;

        SoftValue(K key, V value, ReferenceQueue<V> q) {
            super(value, q);
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public V setValue(V value) {
            throw new RuntimeException("Not implemented");
        }
    }
}

