/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class FunctionScoreQuery
extends Query {
    Query subQuery;
    final ScoreFunction function;
    float maxBoost = Float.MAX_VALUE;
    CombineFunction combineFunction;

    public FunctionScoreQuery(Query subQuery, ScoreFunction function) {
        this.subQuery = subQuery;
        this.function = function;
        this.combineFunction = function.getDefaultScoreCombiner();
    }

    public void setCombineFunction(CombineFunction combineFunction) {
        this.combineFunction = combineFunction;
    }

    public void setMaxBoost(float maxBoost) {
        this.maxBoost = maxBoost;
    }

    public float getMaxBoost() {
        return this.maxBoost;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public ScoreFunction getFunction() {
        return this.function;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ == this.subQuery) {
            return this;
        }
        FunctionScoreQuery bq = (FunctionScoreQuery)this.clone();
        bq.subQuery = newQ;
        return bq;
    }

    public void extractTerms(Set<Term> terms) {
        this.subQuery.extractTerms(terms);
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Weight subQueryWeight = this.subQuery.createWeight(searcher);
        return new CustomBoostFactorWeight(subQueryWeight);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("function score (").append(this.subQuery.toString(field)).append(",function=").append(this.function).append(')');
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery other = (FunctionScoreQuery)((Object)o);
        return this.getBoost() == other.getBoost() && this.subQuery.equals((Object)other.subQuery) && this.function.equals(other.function) && this.maxBoost == other.maxBoost;
    }

    public int hashCode() {
        return this.subQuery.hashCode() + 31 * this.function.hashCode() ^ Float.floatToIntBits(this.getBoost());
    }

    static class CustomBoostFactorScorer
    extends Scorer {
        private final float subQueryBoost;
        private final Scorer scorer;
        private final ScoreFunction function;
        private final float maxBoost;
        private final CombineFunction scoreCombiner;

        private CustomBoostFactorScorer(CustomBoostFactorWeight w, Scorer scorer, ScoreFunction function, float maxBoost, CombineFunction scoreCombiner) throws IOException {
            super((Weight)w);
            this.subQueryBoost = w.getQuery().getBoost();
            this.scorer = scorer;
            this.function = function;
            this.maxBoost = maxBoost;
            this.scoreCombiner = scoreCombiner;
        }

        public int docID() {
            return this.scorer.docID();
        }

        public int advance(int target) throws IOException {
            return this.scorer.advance(target);
        }

        public int nextDoc() throws IOException {
            return this.scorer.nextDoc();
        }

        public float score() throws IOException {
            float score = this.scorer.score();
            return this.scoreCombiner.combine(this.subQueryBoost, score, this.function.score(this.scorer.docID(), score), this.maxBoost);
        }

        public int freq() throws IOException {
            return this.scorer.freq();
        }

        public long cost() {
            return this.scorer.cost();
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        final Weight subQueryWeight;

        public CustomBoostFactorWeight(Weight subQueryWeight) throws IOException {
            this.subQueryWeight = subQueryWeight;
        }

        public Query getQuery() {
            return FunctionScoreQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            float sum = this.subQueryWeight.getValueForNormalization();
            return sum *= FunctionScoreQuery.this.getBoost() * FunctionScoreQuery.this.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
            this.subQueryWeight.normalize(norm, topLevelBoost * FunctionScoreQuery.this.getBoost());
        }

        public Scorer scorer(AtomicReaderContext context, Bits acceptDocs) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(context, acceptDocs);
            if (subQueryScorer == null) {
                return null;
            }
            FunctionScoreQuery.this.function.setNextReader(context);
            return new CustomBoostFactorScorer(this, subQueryScorer, FunctionScoreQuery.this.function, FunctionScoreQuery.this.maxBoost, FunctionScoreQuery.this.combineFunction);
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            Explanation subQueryExpl = this.subQueryWeight.explain(context, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            FunctionScoreQuery.this.function.setNextReader(context);
            Explanation functionExplanation = FunctionScoreQuery.this.function.explainScore(doc, subQueryExpl.getValue());
            return FunctionScoreQuery.this.combineFunction.explain(FunctionScoreQuery.this.getBoost(), subQueryExpl, functionExplanation, FunctionScoreQuery.this.maxBoost);
        }
    }
}

