/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.impl;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.CredentialProviderFactoryShim;
import org.apache.accumulo.core.conf.Property;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConfigurationUtil {
    private static final Logger log = LoggerFactory.getLogger(ServerConfigurationUtil.class);

    public static AccumuloConfiguration getConfiguration(Instance instance) {
        return instance.getConfiguration();
    }

    public static AccumuloConfiguration convertClientConfig(final AccumuloConfiguration base, final Configuration config) {
        return new AccumuloConfiguration(){

            @Override
            public String get(Property property) {
                org.apache.hadoop.conf.Configuration hadoopConf;
                String key = property.getKey();
                if (property.isSensitive() && null != (hadoopConf = this.getHadoopConfiguration())) {
                    try {
                        char[] value = CredentialProviderFactoryShim.getValueFromCredentialProvider(hadoopConf, key);
                        if (null != value) {
                            log.trace("Loaded sensitive value for {} from CredentialProvider", (Object)key);
                            return new String(value);
                        }
                        log.trace("Tried to load sensitive value for {} from CredentialProvider, but none was found", (Object)key);
                    }
                    catch (IOException e) {
                        log.warn("Failed to extract sensitive property ({}) from Hadoop CredentialProvider, falling back to base AccumuloConfiguration", (Object)key, (Object)e);
                    }
                }
                if (config.containsKey(key)) {
                    return config.getString(key);
                }
                return base.get(property);
            }

            @Override
            public void getProperties(Map<String, String> props, AccumuloConfiguration.PropertyFilter filter) {
                base.getProperties(props, filter);
                Iterator keyIter = config.getKeys();
                while (keyIter.hasNext()) {
                    String key = (String)keyIter.next();
                    if (!filter.accept(key)) continue;
                    props.put(key, config.getString(key));
                }
                org.apache.hadoop.conf.Configuration hadoopConf = this.getHadoopConfiguration();
                if (null != hadoopConf) {
                    try {
                        for (String key : CredentialProviderFactoryShim.getKeys(hadoopConf)) {
                            char[] value;
                            if (!Property.isValidPropertyKey(key) || !Property.isSensitive(key) || !filter.accept(key) || null == (value = CredentialProviderFactoryShim.getValueFromCredentialProvider(hadoopConf, key))) continue;
                            props.put(key, new String(value));
                        }
                    }
                    catch (IOException e) {
                        log.warn("Failed to extract sensitive properties from Hadoop CredentialProvider, falling back to accumulo-site.xml", (Throwable)e);
                    }
                }
            }

            private org.apache.hadoop.conf.Configuration getHadoopConfiguration() {
                String credProviderPaths = config.getString(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey());
                if (null != credProviderPaths && !credProviderPaths.isEmpty()) {
                    org.apache.hadoop.conf.Configuration hadoopConf = new org.apache.hadoop.conf.Configuration();
                    hadoopConf.set("hadoop.security.credential.provider.path", credProviderPaths);
                    return hadoopConf;
                }
                log.trace("Did not find credential provider configuration in ClientConfiguration");
                return null;
            }
        };
    }
}

