/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.cassandra.client.RingCache;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.util.Progressable;
import org.apache.thrift.transport.TTransport;

public abstract class AbstractColumnFamilyRecordWriter<K, Y>
extends org.apache.hadoop.mapreduce.RecordWriter<K, Y>
implements RecordWriter<K, Y> {
    protected final Configuration conf;
    protected final RingCache ringCache;
    protected final int queueSize;
    protected final long batchThreshold;
    protected final ConsistencyLevel consistencyLevel;
    protected Progressable progressable;
    protected TaskAttemptContext context;

    protected AbstractColumnFamilyRecordWriter(Configuration conf) {
        this.conf = conf;
        this.ringCache = new RingCache(conf);
        this.queueSize = conf.getInt("mapreduce.output.columnfamilyoutputformat.queue.size", 32 * FBUtilities.getAvailableProcessors());
        this.batchThreshold = conf.getLong("mapreduce.output.columnfamilyoutputformat.batch.threshold", 32L);
        this.consistencyLevel = ConsistencyLevel.valueOf((String)ConfigHelper.getWriteConsistencyLevel(conf));
    }

    public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        this.close();
    }

    @Deprecated
    public void close(Reporter reporter) throws IOException {
        this.close();
    }

    protected abstract void close() throws IOException;

    public abstract class AbstractRangeClient<K>
    extends Thread {
        protected final List<InetAddress> endpoints;
        protected final BlockingQueue<K> queue;
        protected volatile boolean run;
        protected volatile IOException lastException;
        protected Cassandra.Client client;

        public AbstractRangeClient(List<InetAddress> endpoints) {
            super("client-" + endpoints);
            this.queue = new ArrayBlockingQueue<K>(AbstractColumnFamilyRecordWriter.this.queueSize);
            this.run = true;
            this.endpoints = endpoints;
        }

        /*
         * Exception decompiling
         */
        public void put(K value) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void close() throws IOException {
            this.run = false;
            this.interrupt();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            if (this.lastException != null) {
                throw this.lastException;
            }
        }

        protected void closeInternal() {
            TTransport transport;
            if (this.client != null && (transport = this.client.getOutputProtocol().getTransport()).isOpen()) {
                transport.close();
            }
        }

        @Override
        public abstract void run();

        @Override
        public String toString() {
            return "#<Client for " + this.endpoints.toString() + ">";
        }
    }
}

