/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf.rdfa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.semarglproject.rdf.rdfa.DocumentContext;
import org.semarglproject.rdf.rdfa.Vocabulary;
import org.semarglproject.ri.MalformedCurieException;
import org.semarglproject.ri.MalformedIriException;
import org.semarglproject.ri.RIUtils;

final class EvalContext {
    private static final Map<String, String> RDFA11_INITIAL_CONTEXT = new HashMap<String, String>();
    private static final Pattern TERM_PATTERN = Pattern.compile("[a-zA-Z0-9_-]+", 32);
    private static final String CAN_NOT_RESOLVE_TERM = "Can't resolve term ";
    private static final String XHTML_VOCAB = "http://www.w3.org/1999/xhtml/vocab#";
    private static final String POWDER_DESCRIBED_BY = "http://www.w3.org/2007/05/powder-s#describedby";
    private static final String[] XHTML_VOCAB_PROPS = new String[]{"alternate", "appendix", "bookmark", "cite", "chapter", "contents", "copyright", "first", "glossary", "help", "icon", "index", "itsRules", "last", "license", "meta", "next", "p3pv1", "prev", "previous", "role", "section", "stylesheet", "subsection", "start", "top", "up", "banner", "complementary", "contentinfo", "definition", "main", "navigation", "note", "search", "alert", "alertdialog", "application", "article", "button", "checkbox", "columnheader", "combobox", "dialog", "directory", "document", "form", "grid", "gridcell", "group", "heading", "img", "link", "list", "listbox", "listitem", "log", "marquee", "math", "menu", "menubar", "menuitem", "menuitemcheckbox", "menuitemradio", "option", "presentation", "progressbar", "radio", "radiogroup", "region", "row", "rowgroup", "rowheader", "scrollbar", "separator", "slider", "spinbutton", "status", "tab", "tablist", "tabpanel", "textbox", "timer", "toolbar", "tooltip", "tree", "treegrid", "treeitem"};
    Map<String, String> iriMappings = null;
    String subject = null;
    String object = null;
    List<Object> incomplTriples = new ArrayList<Object>();
    String lang;
    String objectLit;
    String objectLitDt;
    List<String> properties;
    boolean parsingLiteral;
    Map<String, List<String>> listMapping;
    private final DocumentContext documentContext;
    private Vocabulary vocab;
    private String profile;

    private EvalContext(String lang, Vocabulary vocab, String profile, DocumentContext documentContext) {
        this.lang = lang;
        this.objectLit = null;
        this.objectLitDt = null;
        this.vocab = vocab;
        this.profile = profile;
        this.properties = null;
        this.parsingLiteral = false;
        this.listMapping = null;
        this.documentContext = documentContext;
    }

    static EvalContext createInitialContext(DocumentContext documentContext) {
        EvalContext initialContext = new EvalContext(null, null, null, documentContext);
        initialContext.subject = documentContext.base;
        initialContext.listMapping = new HashMap<String, List<String>>();
        initialContext.iriMappings = new TreeMap<String, String>();
        return initialContext;
    }

    EvalContext initChildContext(String profile, String vocab, String lang, Map<String, String> overwriteMappings) {
        EvalContext current = new EvalContext(this.lang, this.vocab, this.profile, this.documentContext);
        current.listMapping = this.listMapping;
        current.initPrefixMappings(this.iriMappings, overwriteMappings);
        if (this.documentContext.rdfaVersion > 1) {
            if (profile != null) {
                String newProfile = profile + "#";
                current.profile = current.profile == null ? newProfile : newProfile + ' ' + current.profile;
            }
            if (vocab != null) {
                current.vocab = vocab.length() == 0 ? null : this.documentContext.loadVocabulary(vocab);
            }
        }
        if (lang != null) {
            current.lang = lang;
        }
        if (current.lang != null && current.lang.isEmpty()) {
            current.lang = null;
        }
        return current;
    }

    private void initPrefixMappings(Map<String, String> parentMappings, Map<String, String> overwriteMappings) {
        if (overwriteMappings.isEmpty()) {
            this.iriMappings = parentMappings;
        } else {
            this.iriMappings = new TreeMap<String, String>(parentMappings);
            this.iriMappings.putAll(overwriteMappings);
        }
        if (this.documentContext.rdfaVersion > 1) {
            for (String prefix : overwriteMappings.keySet()) {
                String standardMapping = RDFA11_INITIAL_CONTEXT.get(prefix);
                String newMapping = overwriteMappings.get(prefix);
                if (standardMapping == null || standardMapping.equals(newMapping)) continue;
                this.documentContext.parser.warning("http://www.w3.org/ns/rdfa#PrefixRedefinition", "Standard prefix " + prefix + ": redefined to <" + newMapping + '>');
            }
        }
    }

    List<String> getMappingForIri(String iri) {
        if (!this.listMapping.containsKey(iri)) {
            this.listMapping.put(iri, new ArrayList());
        }
        return this.listMapping.get(iri);
    }

    void addContent(String content) {
        this.objectLit = this.objectLit + content;
    }

    void updateBase(String oldBase, String base) {
        if (this.object != null && this.object.equals(oldBase)) {
            this.object = base;
        }
        if (this.subject != null && this.subject.equals(oldBase)) {
            this.subject = base;
        }
    }

    String resolvePredOrDatatype(String value) throws MalformedIriException {
        if (value == null || value.isEmpty()) {
            throw new MalformedIriException("Empty predicate or datatype found");
        }
        if (value == "AUTODETECT_DATE_DATATYPE") {
            return "AUTODETECT_DATE_DATATYPE";
        }
        return this.resolveTermOrCurieOrAbsIri(value);
    }

    String resolveAboutOrResource(String value) throws MalformedIriException {
        String result = this.documentContext.resolveBNode(value);
        if (result != null) {
            return result;
        }
        return this.resolveCurieOrIri(value, false);
    }

    String resolveRole(String value) throws MalformedIriException {
        if (TERM_PATTERN.matcher(value).matches()) {
            return XHTML_VOCAB + value;
        }
        return this.resolveCurieOrIri(value, true);
    }

    private String resolveTermOrCurieOrAbsIri(String value) throws MalformedIriException {
        if (TERM_PATTERN.matcher(value).matches()) {
            if (this.vocab == null && this.documentContext.rdfaVersion > 1 && "describedby".equals(value)) {
                return POWDER_DESCRIBED_BY;
            }
            String term = this.vocab != null ? this.vocab.resolveTerm(value) : EvalContext.resolveXhtmlTerm(value);
            if (term == null) {
                this.documentContext.parser.warning("http://www.w3.org/ns/rdfa#UnresolvedTerm", CAN_NOT_RESOLVE_TERM + value);
                throw new MalformedIriException(CAN_NOT_RESOLVE_TERM + value);
            }
            return term;
        }
        try {
            return this.resolveCurieOrIri(value, true);
        }
        catch (MalformedCurieException e) {
            throw new MalformedIriException(e.getMessage());
        }
    }

    Iterable<String> expand(String pred) {
        if (this.vocab == null) {
            return Collections.EMPTY_LIST;
        }
        return this.vocab.expand(pred);
    }

    private String resolveCurieOrIri(String curie, boolean ignoreRelIri) throws MalformedIriException {
        int delimPos;
        boolean safeSyntax;
        if (!ignoreRelIri && (curie == null || curie.isEmpty())) {
            return this.documentContext.resolveIri(curie);
        }
        boolean bl = safeSyntax = curie.startsWith("[") && curie.endsWith("]");
        if (safeSyntax) {
            curie = curie.substring(1, curie.length() - 1);
        }
        if ((delimPos = curie.indexOf(58)) == -1) {
            if (safeSyntax || ignoreRelIri) {
                throw new MalformedCurieException("CURIE with no prefix (" + curie + ") found");
            }
            return this.documentContext.resolveIri(curie);
        }
        String result = this.resolveMapping(curie, delimPos, safeSyntax);
        if (RIUtils.isIri((String)result)) {
            return result;
        }
        throw new MalformedIriException("Malformed IRI: " + curie);
    }

    private String resolveMapping(String curie, int delimPos, boolean safeSyntax) throws MalformedCurieException {
        String localName = curie.substring(delimPos + 1);
        String prefix = curie.substring(0, delimPos);
        if (prefix.equals("_")) {
            throw new MalformedCurieException("CURIE with invalid prefix (" + curie + ") found");
        }
        if (!this.iriMappings.containsKey(prefix)) {
            if (this.documentContext.rdfaVersion > 1 && RDFA11_INITIAL_CONTEXT.containsKey(prefix)) {
                String nsUri = RDFA11_INITIAL_CONTEXT.get(prefix);
                this.iriMappings.put(prefix, nsUri);
                String result = nsUri + localName;
                if (RIUtils.isIri((String)result)) {
                    return result;
                }
                throw new MalformedCurieException("Malformed CURIE (" + curie + ")");
            }
            if (!safeSyntax && RIUtils.isIri((String)curie)) {
                return curie;
            }
            throw new MalformedCurieException("CURIE with unresolvable prefix found (" + curie + ")");
        }
        return this.iriMappings.get(prefix) + localName;
    }

    private static String resolveXhtmlTerm(String predicate) {
        for (String link : XHTML_VOCAB_PROPS) {
            if (!link.equalsIgnoreCase(predicate)) continue;
            return XHTML_VOCAB + link;
        }
        return null;
    }

    static {
        RDFA11_INITIAL_CONTEXT.put("owl", "http://www.w3.org/2002/07/owl#");
        RDFA11_INITIAL_CONTEXT.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        RDFA11_INITIAL_CONTEXT.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
        RDFA11_INITIAL_CONTEXT.put("rdfa", "http://www.w3.org/ns/rdfa#");
        RDFA11_INITIAL_CONTEXT.put("xhv", XHTML_VOCAB);
        RDFA11_INITIAL_CONTEXT.put("xsd", "http://www.w3.org/2001/XMLSchema#");
        RDFA11_INITIAL_CONTEXT.put("grddl", "http://www.w3.org/2003/g/data-view#");
        RDFA11_INITIAL_CONTEXT.put("ma", "http://www.w3.org/ns/ma-ont#");
        RDFA11_INITIAL_CONTEXT.put("rif", "http://www.w3.org/2007/rif#");
        RDFA11_INITIAL_CONTEXT.put("skos", "http://www.w3.org/2004/02/skos/core#");
        RDFA11_INITIAL_CONTEXT.put("skosxl", "http://www.w3.org/2008/05/skos-xl#");
        RDFA11_INITIAL_CONTEXT.put("wdr", "http://www.w3.org/2007/05/powder#");
        RDFA11_INITIAL_CONTEXT.put("void", "http://rdfs.org/ns/void#");
        RDFA11_INITIAL_CONTEXT.put("wdrs", "http://www.w3.org/2007/05/powder-s#");
        RDFA11_INITIAL_CONTEXT.put("xml", "http://www.w3.org/XML/1998/namespace");
        RDFA11_INITIAL_CONTEXT.put("cc", "http://creativecommons.org/ns#");
        RDFA11_INITIAL_CONTEXT.put("ctag", "http://commontag.org/ns#");
        RDFA11_INITIAL_CONTEXT.put("dc", "http://purl.org/dc/terms/");
        RDFA11_INITIAL_CONTEXT.put("dcterms", "http://purl.org/dc/terms/");
        RDFA11_INITIAL_CONTEXT.put("foaf", "http://xmlns.com/foaf/0.1/");
        RDFA11_INITIAL_CONTEXT.put("gr", "http://purl.org/goodrelations/v1#");
        RDFA11_INITIAL_CONTEXT.put("ical", "http://www.w3.org/2002/12/cal/icaltzd#");
        RDFA11_INITIAL_CONTEXT.put("og", "http://ogp.me/ns#");
        RDFA11_INITIAL_CONTEXT.put("rev", "http://purl.org/stuff/rev#");
        RDFA11_INITIAL_CONTEXT.put("sioc", "http://rdfs.org/sioc/ns#");
        RDFA11_INITIAL_CONTEXT.put("v", "http://rdf.data-vocabulary.org/#");
        RDFA11_INITIAL_CONTEXT.put("vcard", "http://www.w3.org/2006/vcard/ns#");
        RDFA11_INITIAL_CONTEXT.put("schema", "http://schema.org/");
    }
}

