/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.recurrent;

import net.jodah.recurrent.RetryPolicy;
import net.jodah.recurrent.RetryStats;
import net.jodah.recurrent.internal.util.Assert;

public class Invocation
extends RetryStats {
    volatile boolean retryRequested;
    volatile boolean completionRequested;
    volatile Object result;
    volatile Throwable failure;

    public Invocation(RetryPolicy retryPolicy) {
        super(retryPolicy);
    }

    public void complete() {
        this.complete(null);
    }

    public void complete(Object result) {
        Assert.state(!this.completionRequested, "Complete has already been called", new Object[0]);
        Assert.state(!this.retryRequested, "Retry has already been called", new Object[0]);
        this.completionRequested = true;
        this.result = result;
    }

    public void completeExceptionally(Throwable failure) {
        Assert.state(!this.completionRequested, "Complete has already been called", new Object[0]);
        Assert.state(!this.retryRequested, "Retry has already been called", new Object[0]);
        this.completionRequested = true;
        this.failure = failure;
    }

    public boolean retry() {
        return this.retryInternal(null, null, false);
    }

    public boolean retryOn(Throwable failure) {
        Assert.notNull(failure, "failure");
        return this.retryInternal(null, failure, true);
    }

    public boolean retryWhen(Object result) {
        Assert.notNull(result, "result");
        return this.retryInternal(result, null, true);
    }

    public boolean retryWhen(Object result, Throwable failure) {
        return this.retryInternal(result, failure, true);
    }

    void reset() {
        this.retryRequested = false;
        this.completionRequested = false;
        this.result = null;
        this.failure = null;
    }

    private boolean retryInternal(Object result, Throwable failure, boolean forResultOrFailure) {
        Assert.state(!this.retryRequested, "Retry has already been called", new Object[0]);
        Assert.state(!this.completionRequested, "Complete has already been called", new Object[0]);
        if (forResultOrFailure ? this.canRetryWhen(result, failure) : this.canRetry()) {
            this.retryRequested = true;
            return true;
        }
        if (failure == null) {
            failure = new RuntimeException("Retry invocations exceeded");
        }
        this.completeExceptionally(failure);
        return false;
    }
}

