/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.function.string;

import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.vocabulary.FN;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;
import org.openrdf.query.algebra.evaluation.function.Function;
import org.openrdf.query.algebra.evaluation.util.QueryEvaluationUtil;

public class StrAfter
implements Function {
    @Override
    public String getURI() {
        return FN.SUBSTRING_AFTER.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("Incorrect number of arguments for STRAFTER: " + args.length);
        }
        Value leftArg = args[0];
        Value rightArg = args[1];
        if (leftArg instanceof Literal && rightArg instanceof Literal) {
            Literal leftLit = (Literal)leftArg;
            Literal rightLit = (Literal)rightArg;
            if (QueryEvaluationUtil.compatibleArguments(leftLit, rightLit)) {
                String lexicalValue = leftLit.getLabel();
                String substring = rightLit.getLabel();
                String leftLanguage = leftLit.getLanguage();
                URI leftDt = leftLit.getDatatype();
                int index = lexicalValue.indexOf(substring);
                String substringAfter = "";
                if (index > -1) {
                    substringAfter = lexicalValue.substring((index += substring.length() - 1) + 1, lexicalValue.length());
                } else {
                    leftLanguage = null;
                    leftDt = null;
                }
                if (leftLanguage != null) {
                    return valueFactory.createLiteral(substringAfter, leftLanguage);
                }
                if (leftDt != null) {
                    return valueFactory.createLiteral(substringAfter, leftDt);
                }
                return valueFactory.createLiteral(substringAfter);
            }
            throw new ValueExprEvaluationException("incompatible operands for STRAFTER: " + leftArg + ", " + rightArg);
        }
        throw new ValueExprEvaluationException("incompatible operands for STRAFTER: " + leftArg + ", " + rightArg);
    }
}

