/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.configuration.Configuration;
import com.thinkaurelius.titan.graphdb.relations.EdgeDirection;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.hadoop.FaunusEdgeLabel;
import com.thinkaurelius.titan.hadoop.FaunusPathElement;
import com.thinkaurelius.titan.hadoop.FaunusPropertyKey;
import com.thinkaurelius.titan.hadoop.FaunusRelation;
import com.thinkaurelius.titan.hadoop.FaunusRelationType;
import com.thinkaurelius.titan.hadoop.FaunusSerializer;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.SimpleFaunusEdge;
import com.thinkaurelius.titan.hadoop.SimpleFaunusProperty;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.StandardFaunusProperty;
import com.tinkerpop.blueprints.Direction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StandardFaunusRelation
extends FaunusPathElement
implements FaunusRelation {
    private FaunusRelationType type;
    private static final Logger log = LoggerFactory.getLogger(StandardFaunusRelation.class);

    public StandardFaunusRelation(Configuration config, long id, FaunusRelationType type) {
        super(config, id);
        this.type = type;
        Preconditions.checkNotNull((Object)((Object)this.type));
    }

    @Override
    void updateSchema(FaunusSerializer.Schema schema) {
        super.updateSchema(schema);
        schema.add(this.type);
    }

    @Override
    public void setProperty(FaunusRelationType type, Object value) {
        if (type.isPropertyKey()) {
            Preconditions.checkArgument((!((FaunusPropertyKey)type).isImplicit() ? 1 : 0) != 0, (String)"Cannot set implicit properties: %s", (Object[])new Object[]{type});
            this.setRelation(new SimpleFaunusProperty((FaunusPropertyKey)type, value));
        } else {
            FaunusEdgeLabel label = (FaunusEdgeLabel)type;
            Preconditions.checkArgument((boolean)(value instanceof FaunusVertex), (String)"Vertex expected but got: %s", (Object[])new Object[]{value});
            this.setRelation(new SimpleFaunusEdge(label, (FaunusVertex)value));
        }
    }

    public String getTypeName() {
        return null != this.type ? this.type.getName() : null;
    }

    public boolean isProperty() {
        return this.type.isPropertyKey();
    }

    public boolean isEdge() {
        return this.type.isEdgeLabel();
    }

    public int getArity() {
        return this.type.isPropertyKey() ? 1 : 2;
    }

    public abstract TitanVertex getVertex(int var1);

    public Direction getDirection(TitanVertex vertex) {
        for (int i = 0; i < this.getArity(); ++i) {
            if (!this.getVertex(i).equals(vertex)) continue;
            return EdgeDirection.fromPosition((int)i);
        }
        throw new IllegalArgumentException("Relation is not incident on vertex");
    }

    public boolean isIncidentOn(TitanVertex vertex) {
        for (int i = 0; i < this.getArity(); ++i) {
            if (!this.getVertex(i).equals(vertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isHidden() {
        return this.type.isHiddenType();
    }

    public boolean isLoop() {
        return this.getArity() == 2 && this.getVertex(0).equals(this.getVertex(1));
    }

    @Override
    public FaunusRelationType getType() {
        return this.type;
    }

    @Override
    public Object getId() {
        if (!this.hasId()) {
            return null;
        }
        long[] ids = new long[this.isProperty() ? 3 : 4];
        ids[0] = this.getLongId();
        ids[2] = this.type.getLongId();
        if (this.isProperty()) {
            ids[1] = ((StandardFaunusProperty)this).getVertex().getLongId();
        } else {
            StandardFaunusEdge edge = (StandardFaunusEdge)this;
            ids[1] = edge.getVertex(Direction.OUT).getLongId();
            ids[3] = edge.getVertex(Direction.IN).getLongId();
        }
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] > 0L) continue;
            return null;
        }
        return RelationIdentifier.get((long[])ids);
    }

    @Override
    public Iterable<RelationType> getPropertyKeysDirect() {
        return super.getPropertyKeysDirect();
    }

    protected void setType(FaunusRelationType t) {
        this.type = t;
        Preconditions.checkNotNull((Object)((Object)this.type));
    }
}

