/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.config;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.HadoopConfiguration;
import com.thinkaurelius.titan.hadoop.config.TitanHadoopConfiguration;
import com.tinkerpop.blueprints.Direction;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;

public class ModifiableHadoopConfiguration
extends ModifiableConfiguration {
    private static final ModifiableHadoopConfiguration IMMUTABLE_CFG_WITH_RESOURCES;
    private final Configuration conf;
    private volatile Boolean trackPaths;
    private volatile Boolean trackState;

    public ModifiableHadoopConfiguration() {
        this(new Configuration());
    }

    public ModifiableHadoopConfiguration(Configuration c) {
        super(TitanHadoopConfiguration.ROOT_NS, (WriteConfiguration)new HadoopConfiguration(c), BasicConfiguration.Restriction.NONE);
        this.conf = c;
    }

    public static ModifiableHadoopConfiguration immutableWithResources() {
        return IMMUTABLE_CFG_WITH_RESOURCES;
    }

    public static ModifiableHadoopConfiguration withoutResources() {
        return new ModifiableHadoopConfiguration(new Configuration(false));
    }

    public static ModifiableHadoopConfiguration of(Configuration c) {
        Preconditions.checkNotNull((Object)c);
        return new ModifiableHadoopConfiguration(c);
    }

    public Configuration getHadoopConfiguration() {
        return this.conf;
    }

    public <O> O get(ConfigOption<O> option, String ... umbrellaElements) {
        if (TitanHadoopConfiguration.PIPELINE_TRACK_PATHS == option) {
            Boolean b = this.trackPaths;
            if (null == b) {
                this.trackPaths = b = (Boolean)super.get(option, umbrellaElements);
            }
            return (O)b;
        }
        if (TitanHadoopConfiguration.PIPELINE_TRACK_STATE == option) {
            Boolean b = this.trackState;
            if (null == b) {
                this.trackState = b = (Boolean)super.get(option, umbrellaElements);
            }
            return (O)b;
        }
        return (O)super.get(option, umbrellaElements);
    }

    public <O> ModifiableConfiguration set(ConfigOption<O> option, O value, String ... umbrellaElements) {
        if (TitanHadoopConfiguration.PIPELINE_TRACK_PATHS == option) {
            this.trackPaths = null;
        } else if (TitanHadoopConfiguration.PIPELINE_TRACK_STATE == option) {
            this.trackState = null;
        }
        return super.set(option, value, umbrellaElements);
    }

    public void setAllOutput(Map<ConfigElement.PathIdentifier, Object> entries) {
        ModifiableConfiguration out = this.getOutputConf();
        for (Map.Entry<ConfigElement.PathIdentifier, Object> entry : entries.entrySet()) {
            Preconditions.checkArgument((boolean)entry.getKey().element.isOption());
            out.set((ConfigOption)entry.getKey().element, entry.getValue(), entry.getKey().umbrellaElements);
        }
    }

    public void setAllInput(Map<ConfigElement.PathIdentifier, Object> entries) {
        ModifiableConfiguration in = this.getInputConf();
        for (Map.Entry<ConfigElement.PathIdentifier, Object> entry : entries.entrySet()) {
            Preconditions.checkArgument((boolean)entry.getKey().element.isOption());
            in.set((ConfigOption)entry.getKey().element, entry.getValue(), entry.getKey().umbrellaElements);
        }
    }

    public Class<?> getClass(ConfigOption<String> opt, Class<?> cls) {
        return this.conf.getClass(ConfigElement.getPath(opt, (String[])new String[0]), cls);
    }

    public <T> Class<? extends T> getClass(ConfigOption<String> opt, Class<? extends T> defaultValue, Class<T> iface) {
        return this.conf.getClass(ConfigElement.getPath(opt, (String[])new String[0]), defaultValue, iface);
    }

    public void setClass(ConfigOption<String> opt, Class<?> cls, Class<?> iface) {
        this.conf.setClass(ConfigElement.getPath(opt, (String[])new String[0]), cls, iface);
    }

    public ModifiableConfiguration getInputConf(ConfigNamespace root) {
        HadoopConfiguration inconf = new HadoopConfiguration(this.conf, ConfigElement.getPath((ConfigElement)TitanHadoopConfiguration.INPUT_CONF_NS, (String[])new String[0]) + ".");
        return new ModifiableConfiguration(root, (WriteConfiguration)inconf, BasicConfiguration.Restriction.NONE);
    }

    public ModifiableConfiguration getInputConf() {
        return this.getInputConf(GraphDatabaseConfiguration.ROOT_NS);
    }

    public ModifiableConfiguration getOutputConf(ConfigNamespace root) {
        HadoopConfiguration outconf = new HadoopConfiguration(this.conf, ConfigElement.getPath((ConfigElement)TitanHadoopConfiguration.OUTPUT_CONF_NS, (String[])new String[0]) + ".");
        return new ModifiableConfiguration(root, (WriteConfiguration)outconf, BasicConfiguration.Restriction.NONE);
    }

    public ModifiableConfiguration getOutputConf() {
        return this.getOutputConf(GraphDatabaseConfiguration.ROOT_NS);
    }

    public Direction getEdgeCopyDirection() {
        if (this.has(TitanHadoopConfiguration.INPUT_EDGE_COPY_DIRECTION, new String[0])) {
            return this.get(TitanHadoopConfiguration.INPUT_EDGE_COPY_DIRECTION, new String[0]);
        }
        if (this.has(TitanHadoopConfiguration.INPUT_EDGE_COPY_DIR, new String[0])) {
            return this.get(TitanHadoopConfiguration.INPUT_EDGE_COPY_DIR, new String[0]);
        }
        return (Direction)TitanHadoopConfiguration.INPUT_EDGE_COPY_DIRECTION.getDefaultValue();
    }

    static {
        Configuration immutable = HadoopCompatLoader.DEFAULT_COMPAT.newImmutableConfiguration(new Configuration(true));
        IMMUTABLE_CFG_WITH_RESOURCES = new ModifiableHadoopConfiguration(immutable);
    }
}

