/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.config;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigNamespace;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Element;
import javax.annotation.Nullable;

public class TitanHadoopConfiguration {
    public static final ConfigNamespace ROOT_NS = new ConfigNamespace(null, "faunus", "Faunus configuration root");
    public static final ConfigNamespace TRUNK_NS = new ConfigNamespace(new ConfigNamespace(ROOT_NS, "titan", "titan-hadoop namespace"), "hadoop", "Titan-Hadoop configuration parent");
    public static final ConfigNamespace MAPRED_NS = new ConfigNamespace(TRUNK_NS, "mr", "MapReduce configuration aspects that cut across input and output");
    public static final ConfigOption<String> CLASSPATH_CONFIGURER = new ConfigOption(MAPRED_NS, "classpath-configurer", "The full package and classname of a JobClasspathConfigurer implementation.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigNamespace INPUT_NS = new ConfigNamespace(TRUNK_NS, "input", "Graph input format configuration");
    public static final ConfigOption<String> INPUT_FORMAT = new ConfigOption(INPUT_NS, "format", "Package and classname of the input format class.  This must implement the Hadoop InputFormat interface.", ConfigOption.Type.LOCAL, (Object)"current");
    public static final ConfigOption<String> INPUT_LOCATION = new ConfigOption(INPUT_NS, "location", "Path to the default input file", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigNamespace INPUT_CONF_NS = new ConfigNamespace(INPUT_NS, "conf", "Settings for the input format class");
    public static final ConfigOption<String> INPUT_VERTEX_QUERY_FILTER = new ConfigOption(INPUT_NS, "vertex-query-filter", "A Gremlin vertex-centric query which limits the relations read by Faunus for each vertex.  This query string should assume the variable v represents a vertex (Faunus binds the v variable automatically before evaluating this query string).", ConfigOption.Type.LOCAL, (Object)"v.query()");
    public static final ConfigOption<String> TITAN_INPUT_VERSION = new ConfigOption(INPUT_NS, "db-version", "The version of the Titan database being read", ConfigOption.Type.LOCAL, (Object)"current");
    public static final ConfigOption<Direction> INPUT_EDGE_COPY_DIRECTION = new ConfigOption(INPUT_NS, "edge-copy-direction", "The edge direction to read and mirror in the opposing direction. OUT creates IN edges.  IN creates out EDGES.  BOTH is not supported. ", ConfigOption.Type.LOCAL, Direction.class, (Object)Direction.OUT);
    @Deprecated
    public static final ConfigOption<Direction> INPUT_EDGE_COPY_DIR = new ConfigOption(INPUT_NS, "edge-copy-dir", "The edge direction to read and mirror in the opposing direction. OUT creates IN edges.  IN creates out EDGES.  BOTH is not supported.", ConfigOption.Type.LOCAL, Direction.class, (Object)Direction.OUT, ConfigOption.disallowEmpty(Direction.class), INPUT_EDGE_COPY_DIRECTION);
    public static final ConfigNamespace OUTPUT_NS = new ConfigNamespace(TRUNK_NS, "output", "Graph output format configuration");
    public static final ConfigOption<String> OUTPUT_FORMAT = new ConfigOption(OUTPUT_NS, "format", "Package and classname of the output format class.  This must implment the Hadoop OutputFormat interface.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<Boolean> OUTPUT_INFER_SCHEMA = new ConfigOption(OUTPUT_NS, "infer-schema", "Whether to attempt to automatically create Titan property keys and labels before writing data", ConfigOption.Type.LOCAL, (Object)true);
    public static final ConfigOption<Boolean> OUTPUT_TITAN_TYPE_CHECKING = new ConfigOption(OUTPUT_NS, "titan-type-checking", "Attempt to load and enforce Titan schema information as early as possible in the job pipeline, typically in the first mapper that executes as part of a Titan-Hadoop pipeline.  This option is only useful when reading ungroomed data from an input source that does not provide intrinsic integrity guarantees, such as RDF or GraphSON files, and writing those same data out to Titan.  This option is meaningless and must be false or unspecified when either the output format is not a Titan output format or when the input format is a Titan input format (or both).", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigOption<String> OUTPUT_LOADER_SCRIPT_FILE = new ConfigOption(OUTPUT_NS, "loader-script-file", "The path to a Titan vertex/edge/property loader script.  This option only has an effect when writing output using one of the Titan*OutputFormat format classes.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigNamespace JOBDIR_NS = new ConfigNamespace(TRUNK_NS, "jobdir", "Temporary SequenceFile configuration");
    public static final ConfigOption<String> JOBDIR_LOCATION = new ConfigOption(JOBDIR_NS, "location", "An HDFS path used to store temporary SequenceFiles in between executions of MR jobs chained together by Titan-Hadoop", ConfigOption.Type.LOCAL, (Object)"jobs");
    public static final ConfigOption<Boolean> JOBDIR_OVERWRITE = new ConfigOption(JOBDIR_NS, "overwrite", "Whether to temporary SequenceFiles", ConfigOption.Type.LOCAL, (Object)true);
    public static final ConfigNamespace OUTPUT_CONF_NS = new ConfigNamespace(OUTPUT_NS, "conf", "Settings for the output format class");
    public static final ConfigOption<String> FINAL_OUTPUT_LOCATION = new ConfigOption(OUTPUT_NS, "location", "Titan-Hadoop writes the output of each Hadoop job to a subdirectory named job-<N> for N=0,1,...(N-1) in " + ConfigElement.getPath(JOBDIR_LOCATION, (String[])new String[0]) + " by default.  However, when this option is set, the output " + "of the final job (N-1) in a Titan-Hadoop pipeline will instead be written to the name directory.  " + "This option works by calling SequenceFileOutputFormat.setOutputPath, so it generally only applies " + "to output formats which are descendants of FileOutputFormat.  In particular, this option has no effect " + "on output formats that write to a Titan graph.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigNamespace PIPELINE_NS = new ConfigNamespace(TRUNK_NS, "pipeline", "MapReduce job cascading configuration");
    public static final ConfigOption<Boolean> PIPELINE_TRACK_STATE = new ConfigOption(PIPELINE_NS, "track-state", "Whether to keep intermediate state information", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigOption<Boolean> PIPELINE_TRACK_PATHS = new ConfigOption(PIPELINE_NS, "track-paths", "Whether to keep intermediate traversal path information", ConfigOption.Type.LOCAL, (Object)false);
    public static final ConfigOption<Integer> PIPELINE_MAP_SPILL_OVER = new ConfigOption(PIPELINE_NS, "map-spill-over", "The maximum number of map entries held in memory during computation; maps that grow past this entry limit will be partially written to disk", ConfigOption.Type.LOCAL, (Object)500);
    public static final ConfigNamespace SIDE_EFFECT_NS = new ConfigNamespace(TRUNK_NS, "sideeffect", "Side-effect output format configuration");
    public static final ConfigOption<String> SIDE_EFFECT_FORMAT = new ConfigOption(SIDE_EFFECT_NS, "format", "Package and classname of the output format to use for computation side effects.  This must implement the Hadoop OutputFormat interface.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigNamespace SERIALIZER_NS = new ConfigNamespace(TRUNK_NS, "serializer", "Serializer configuration");
    public static final ConfigOption<Integer> KRYO_MAX_OUTPUT_SIZE = new ConfigOption(SERIALIZER_NS, "max-output-buffer-size", "The maximum size, in bytes, of any single object serialized by Kryo.  Attempts to serialize objects with larger serialized representations will generate an exception.  This should be set large enough to accommodate any single sane datum written by Kryo, and serves as a last-resort sanity check to avoid erroneously serializing reference cycles.", ConfigOption.Type.LOCAL, Integer.class, (Object)0xA00000);
    public static final ConfigNamespace INDEX_NS = new ConfigNamespace(TRUNK_NS, "reindex", "Index repair configuration");
    public static final ConfigOption<String> INDEX_NAME = new ConfigOption(INDEX_NS, "name", "The name of a Titan index to build or repair.  The index must already be enabled or installed.", ConfigOption.Type.LOCAL, String.class);
    public static final ConfigOption<String> INDEX_TYPE = new ConfigOption(INDEX_NS, "type", "The relationtype of a Titan index to build or repair.  The index must already be enabled or installed.", ConfigOption.Type.LOCAL, String.class, (Object)"", (Predicate)new Predicate<String>(){

        public boolean apply(@Nullable String input) {
            return null != input;
        }
    });
    public static final ConfigNamespace TRANSFORM_NS = new ConfigNamespace(TRUNK_NS, "transform", "Automatically-set Titan-Hadoop internal options");
    public static final ConfigNamespace VERTICES_VERTICES_NS = new ConfigNamespace(TRANSFORM_NS, "vertices-vertices", "Automatically-set options used by VerticesVerticesMapReduce");
    public static final ConfigOption<Direction> VERTICES_VERTICES_DIRECTION = new ConfigOption(VERTICES_VERTICES_NS, "direction", "TODO", ConfigOption.Type.LOCAL, Direction.class).hide();
    public static final ConfigOption<String[]> VERTICES_VERTICES_LABELS = new ConfigOption(VERTICES_VERTICES_NS, "labels", "TODO", ConfigOption.Type.LOCAL, String[].class, (Object)new String[0], Predicates.alwaysTrue()).hide();
    public static final ConfigNamespace VERTICES_EDGES_NS = new ConfigNamespace(TRANSFORM_NS, "vertices-edges", "Automatically-set options used by VerticesVerticesMapReduce");
    public static final ConfigOption<Direction> VERTICES_EDGES_DIRECTION = new ConfigOption(VERTICES_EDGES_NS, "direction", "TODO", ConfigOption.Type.LOCAL, Direction.class).hide();
    public static final ConfigOption<String[]> VERTICES_EDGES_LABELS = new ConfigOption(VERTICES_EDGES_NS, "labels", "TODO", ConfigOption.Type.LOCAL, String[].class, (Object)new String[0], Predicates.alwaysTrue()).hide();
    public static final ConfigNamespace LINK_NS = new ConfigNamespace(SIDE_EFFECT_NS, "link", "Automatically-set options used by LinkMapReduce");
    public static final ConfigOption<Direction> LINK_DIRECTION = new ConfigOption(LINK_NS, "direction", "TODO", ConfigOption.Type.LOCAL, Direction.class).hide();
    public static final ConfigOption<String> LINK_LABEL = new ConfigOption(LINK_NS, "label", "TODO", ConfigOption.Type.LOCAL, String.class).hide();
    public static final ConfigOption<Integer> LINK_STEP = new ConfigOption(LINK_NS, "step", "TODO", ConfigOption.Type.LOCAL, Integer.class, (Object)-1).hide();
    public static final ConfigOption<Boolean> LINK_MERGE_DUPLICATES = new ConfigOption(LINK_NS, "merge-duplicates", "TODO", ConfigOption.Type.LOCAL, (Object)false).hide();
    public static final ConfigOption<String> LINK_MERGE_WEIGHT_KEY = new ConfigOption(LINK_NS, "merge-weight-key", "TODO", ConfigOption.Type.LOCAL, (Object)"_").hide();
    public static final ConfigNamespace COMMIT_VERTICES_NS = new ConfigNamespace(SIDE_EFFECT_NS, "commit-vertices", "Automatically-set options used by CommitVerticesMapReduce");
    public static final ConfigOption<Tokens.Action> COMMIT_VERTICES_ACTION = new ConfigOption(COMMIT_VERTICES_NS, "action", "TODO", ConfigOption.Type.LOCAL, Tokens.Action.class).hide();
    public static final ConfigNamespace FILTER_NS = new ConfigNamespace(TRUNK_NS, "filter", "Automatically-set options used by the filter package");
    public static final ConfigNamespace BACK_FILTER_NS = new ConfigNamespace(FILTER_NS, "filter", "Automatically-set options used by BackFilterMapReduce");
    public static final ConfigOption<String> BACK_FILTER_CLASS = new ConfigOption(BACK_FILTER_NS, "class", "TODO", ConfigOption.Type.LOCAL, String.class, (Object)Element.class.getCanonicalName()).hide();
    public static final ConfigOption<Integer> BACK_FILTER_STEP = new ConfigOption(BACK_FILTER_NS, "step", "TODO", ConfigOption.Type.LOCAL, Integer.class, (Object)-1).hide();
}

