/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.config.job;

import com.google.common.collect.ImmutableList;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.config.job.JobClasspathConfigurer;
import java.io.File;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobClasspathConfigurers {
    private static final Logger log = LoggerFactory.getLogger(JobClasspathConfigurers.class);
    private static final ImmutableList<String> POSSIBLE_MAPRED_JAR_DIRS;

    public static JobClasspathConfigurer get(String customConfigurer, String configuredMapredJar, String defaultMapredJar) {
        if (null != customConfigurer) {
            log.info("Using configuration's custom {} implementation: {}", (Object)JobClasspathConfigurer.class.getSimpleName(), (Object)customConfigurer);
            try {
                return (JobClasspathConfigurer)Class.forName(customConfigurer).newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (null != configuredMapredJar) {
            log.info("Using configuration's mapred job jar: {}", (Object)configuredMapredJar);
            return HadoopCompatLoader.DEFAULT_COMPAT.newMapredJarConfigurer(configuredMapredJar);
        }
        for (String dir : POSSIBLE_MAPRED_JAR_DIRS) {
            String candidate = dir + File.separator + defaultMapredJar;
            if (!new File(candidate).exists()) continue;
            log.info("Using mapred job jar found in {}: {}", (Object)dir, (Object)candidate);
            return HadoopCompatLoader.DEFAULT_COMPAT.newMapredJarConfigurer(candidate);
        }
        log.info("Uploading jars on classpath DistributedCache in lieu of a mapred job jar");
        return HadoopCompatLoader.DEFAULT_COMPAT.newDistCacheConfigurer();
    }

    static {
        ImmutableList.Builder b = ImmutableList.builder();
        for (String prefix : Arrays.asList("", ".." + File.separator)) {
            for (String dir : Arrays.asList("target", "lib")) {
                b.add((Object)(prefix + dir));
            }
        }
        POSSIBLE_MAPRED_JAR_DIRS = b.build();
    }
}

