/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.cassandra;

import com.thinkaurelius.titan.diskstorage.cassandra.AbstractCassandraStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.formats.cassandra.TitanCassandraRecordReader;
import com.thinkaurelius.titan.hadoop.formats.cassandra.TitanCassandraWideRecordReader;
import com.thinkaurelius.titan.hadoop.formats.util.TitanInputFormat;
import com.thinkaurelius.titan.hadoop.formats.util.input.TitanHadoopSetupCommon;
import java.io.IOException;
import java.util.List;
import org.apache.cassandra.hadoop.ColumnFamilyInputFormat;
import org.apache.cassandra.hadoop.ColumnFamilyRecordReader;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class TitanCassandraInputFormat
extends TitanInputFormat {
    private static final String INPUT_WIDEROWS_CONFIG = "cassandra.input.widerows";
    private static final boolean INPUT_WIDEROWS_DEFAULT = false;
    private static final String RANGE_BATCH_SIZE_CONFIG = "cassandra.range.batch.size";
    private final ColumnFamilyInputFormat columnFamilyInputFormat = new ColumnFamilyInputFormat();
    private Configuration config;

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        return this.columnFamilyInputFormat.getSplits(jobContext);
    }

    public RecordReader<NullWritable, FaunusVertex> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        boolean wideRows = this.config.getBoolean(INPUT_WIDEROWS_CONFIG, false);
        ColumnFamilyRecordReader cfrr = (ColumnFamilyRecordReader)this.columnFamilyInputFormat.createRecordReader(inputSplit, taskAttemptContext);
        return wideRows ? new TitanCassandraWideRecordReader(this, this.vertexQuery, cfrr) : new TitanCassandraRecordReader(this, this.vertexQuery, cfrr);
    }

    @Override
    public void setConf(Configuration config) {
        super.setConf(config);
        ConfigHelper.setInputInitialAddress((Configuration)config, (String)((String[])this.inputConf.get(GraphDatabaseConfiguration.STORAGE_HOSTS, new String[0]))[0]);
        if (this.inputConf.has(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])) {
            ConfigHelper.setInputRpcPort((Configuration)config, (String)String.valueOf(this.inputConf.get(GraphDatabaseConfiguration.STORAGE_PORT, new String[0])));
        }
        if (this.inputConf.has(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0])) {
            ConfigHelper.setInputKeyspaceUserName((Configuration)config, (String)((String)this.inputConf.get(GraphDatabaseConfiguration.AUTH_USERNAME, new String[0])));
        }
        if (this.inputConf.has(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0])) {
            ConfigHelper.setInputKeyspacePassword((Configuration)config, (String)((String)this.inputConf.get(GraphDatabaseConfiguration.AUTH_PASSWORD, new String[0])));
        }
        boolean wideRows = config.getBoolean(INPUT_WIDEROWS_CONFIG, false);
        ConfigHelper.setInputColumnFamily((Configuration)config, (String)((String)this.inputConf.get(AbstractCassandraStoreManager.CASSANDRA_KEYSPACE, new String[0])), (String)"edgestore", (boolean)wideRows);
        SlicePredicate predicate = new SlicePredicate();
        int rangeBatchSize = config.getInt(RANGE_BATCH_SIZE_CONFIG, Integer.MAX_VALUE);
        predicate.setSlice_range(this.getSliceRange(TitanHadoopSetupCommon.getDefaultSliceQuery(), rangeBatchSize));
        ConfigHelper.setInputSlicePredicate((Configuration)config, (SlicePredicate)predicate);
        this.config = config;
    }

    private SliceRange getSliceRange(SliceQuery slice, int limit) {
        SliceRange sliceRange = new SliceRange();
        sliceRange.setStart(slice.getSliceStart().asByteBuffer());
        sliceRange.setFinish(slice.getSliceEnd().asByteBuffer());
        sliceRange.setCount(Math.min(limit, slice.getLimit()));
        return sliceRange;
    }

    public Configuration getConf() {
        return this.config;
    }
}

