/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.formats.script;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.config.ModifiableHadoopConfiguration;
import com.thinkaurelius.titan.hadoop.formats.script.ScriptConfig;
import com.thinkaurelius.titan.hadoop.tinkerpop.gremlin.FaunusGremlinScriptEngine;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class ScriptRecordWriter
extends RecordWriter<NullWritable, FaunusVertex> {
    protected final DataOutputStream out;
    private final ScriptEngine engine = new FaunusGremlinScriptEngine();
    private static final String WRITE_CALL = "write(vertex,output)";
    private static final String VERTEX = "vertex";
    private static final String OUTPUT = "output";

    public ScriptRecordWriter(DataOutputStream out, Configuration configuration) throws IOException {
        this.out = out;
        ModifiableHadoopConfiguration faunusConf = ModifiableHadoopConfiguration.of(configuration);
        FileSystem fs = FileSystem.get((Configuration)configuration);
        try {
            this.engine.put(OUTPUT, this.out);
            this.engine.eval(new InputStreamReader((InputStream)fs.open(new Path((String)faunusConf.getOutputConf(ScriptConfig.ROOT_NS).get(ScriptConfig.SCRIPT_FILE, new String[0])))));
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void write(NullWritable key, FaunusVertex vertex) throws IOException {
        if (null != vertex) {
            try {
                this.engine.put(VERTEX, vertex);
                this.engine.eval(WRITE_CALL);
            }
            catch (ScriptException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public synchronized void close(TaskAttemptContext context) throws IOException {
        this.out.close();
    }
}

