/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.mapreduce.util;

import com.thinkaurelius.titan.hadoop.FaunusVertex;
import com.thinkaurelius.titan.hadoop.StandardFaunusEdge;
import com.thinkaurelius.titan.hadoop.Tokens;
import com.thinkaurelius.titan.hadoop.compat.HadoopCompatLoader;
import com.thinkaurelius.titan.hadoop.mapreduce.util.EmptyConfiguration;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeMapperOutputs;
import com.thinkaurelius.titan.hadoop.mapreduce.util.SafeReducerOutputs;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class CountMapReduce {
    public static final String CLASS = Tokens.makeNamespace(CountMapReduce.class) + ".class";

    public static Configuration createConfiguration(Class<? extends Element> klass) {
        EmptyConfiguration configuration = new EmptyConfiguration();
        configuration.setClass(CLASS, klass, Element.class);
        return configuration;
    }

    public static class Reduce
    extends Reducer<NullWritable, LongWritable, NullWritable, LongWritable> {
        private SafeReducerOutputs outputs;
        private LongWritable longWritable = new LongWritable();

        public void setup(Reducer.Context context) {
            this.outputs = new SafeReducerOutputs(context);
        }

        public void reduce(NullWritable key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long totalCount = 0L;
            for (LongWritable temp : values) {
                totalCount += temp.get();
            }
            this.longWritable.set(totalCount);
            this.outputs.write("sideeffect", (Writable)NullWritable.get(), (Writable)this.longWritable);
        }

        public void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.outputs.close();
        }
    }

    public static class Combiner
    extends Reducer<NullWritable, LongWritable, NullWritable, LongWritable> {
        private final LongWritable longWritable = new LongWritable();

        public void reduce(NullWritable key, Iterable<LongWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            long totalCount = 0L;
            for (LongWritable temp : values) {
                totalCount += temp.get();
            }
            this.longWritable.set(totalCount);
            context.write((Object)key, (Object)this.longWritable);
        }
    }

    public static class Map
    extends Mapper<NullWritable, FaunusVertex, NullWritable, LongWritable> {
        private boolean isVertex;
        private final LongWritable longWritable = new LongWritable();
        private SafeMapperOutputs outputs;

        public void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.isVertex = HadoopCompatLoader.DEFAULT_COMPAT.getContextConfiguration((TaskAttemptContext)context).getClass(CLASS, Element.class, Element.class).equals(Vertex.class);
            this.outputs = new SafeMapperOutputs(context);
        }

        public void map(NullWritable key, FaunusVertex value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.isVertex) {
                long pathCount = value.pathCount();
                this.longWritable.set(pathCount);
                context.write((Object)NullWritable.get(), (Object)this.longWritable);
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.VERTICES_COUNTED, pathCount > 0L ? 1L : 0L);
            } else {
                long edgesCounted = 0L;
                long pathCount = 0L;
                for (Edge e : value.getEdges(Direction.OUT, new String[0])) {
                    StandardFaunusEdge edge = (StandardFaunusEdge)e;
                    if (!edge.hasPaths()) continue;
                    ++edgesCounted;
                    pathCount += edge.pathCount();
                }
                this.longWritable.set(pathCount);
                context.write((Object)NullWritable.get(), (Object)this.longWritable);
                HadoopCompatLoader.DEFAULT_COMPAT.incrementContextCounter((TaskInputOutputContext)context, Counters.EDGES_COUNTED, edgesCounted);
            }
            this.outputs.write("graph", (Writable)NullWritable.get(), (Writable)value);
        }

        public void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            this.outputs.close();
        }
    }

    public static enum Counters {
        VERTICES_COUNTED,
        EDGES_COUNTED;

    }
}

