/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.hadoop.tinkerpop.gremlin;

import com.thinkaurelius.titan.hadoop.tinkerpop.gremlin.ConsolePreferenceChangeListener;
import com.thinkaurelius.titan.hadoop.tinkerpop.gremlin.HadoopGremlin;
import com.thinkaurelius.titan.hadoop.tinkerpop.gremlin.Imports;
import com.thinkaurelius.titan.hadoop.tinkerpop.gremlin.ResultHookClosure;
import com.tinkerpop.gremlin.groovy.Gremlin;
import com.tinkerpop.gremlin.groovy.console.ErrorHookClosure;
import com.tinkerpop.gremlin.groovy.console.NullResultHookClosure;
import com.tinkerpop.gremlin.groovy.console.PromptClosure;
import groovy.lang.Closure;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.prefs.PreferenceChangeListener;
import jline.History;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.codehaus.groovy.tools.shell.InteractiveShellRunner;
import org.codehaus.groovy.tools.shell.Shell;
import org.codehaus.groovy.tools.shell.util.Preferences;

public class Console {
    private static final String HISTORY_FILE = ".gremlin_titan_hadoop_history";
    private static final String STANDARD_INPUT_PROMPT = "gremlin> ";
    private static final String STANDARD_RESULT_PROMPT = "==>";

    public Console(IO io, String inputPrompt, String resultPrompt, String[] cliArgs) {
        io.out.println();
        io.out.println("         \\,,,/");
        io.out.println("         (o o)");
        io.out.println("-----oOOo-(_)-oOOo-----");
        Groovysh groovy = new Groovysh();
        groovy.setResultHook((Closure)new NullResultHookClosure((Object)groovy));
        for (String imps : Imports.getImports()) {
            groovy.execute("import " + imps);
        }
        for (String evs : Imports.getEvaluates()) {
            groovy.execute(evs);
        }
        ConsolePreferenceChangeListener prefListener = new ConsolePreferenceChangeListener();
        Preferences.addChangeListener((PreferenceChangeListener)prefListener);
        ResultHookClosure resultHook = new ResultHookClosure(groovy, io, resultPrompt);
        resultHook.setConsolePreferenceConsumers(prefListener);
        groovy.setResultHook((Closure)resultHook);
        groovy.setHistory(new History());
        InteractiveShellRunner runner = new InteractiveShellRunner((Shell)groovy, (Closure)new PromptClosure((Object)groovy, inputPrompt));
        runner.setErrorHandler((Closure)new ErrorHookClosure((Object)runner, io));
        try {
            runner.setHistory(new History(new File(System.getProperty("user.home") + "/" + HISTORY_FILE)));
        }
        catch (IOException e) {
            io.err.println("Unable to create history file: .gremlin_titan_hadoop_history");
        }
        Gremlin.load();
        HadoopGremlin.load();
        if (null != cliArgs && 0 < cliArgs.length) {
            this.initializeShellWithScript(io, cliArgs[0], groovy);
        }
        try {
            runner.run();
        }
        catch (Error e) {
            // empty catch block
        }
        System.exit(0);
    }

    public Console() {
        this(new IO(System.in, (OutputStream)System.out, (OutputStream)System.err), STANDARD_INPUT_PROMPT, STANDARD_RESULT_PROMPT, new String[0]);
    }

    public Console(String[] cliArgs) {
        this(new IO(System.in, (OutputStream)System.out, (OutputStream)System.err), STANDARD_INPUT_PROMPT, STANDARD_RESULT_PROMPT, cliArgs);
    }

    public static void main(String[] args) {
        new Console(args);
    }

    private void initializeShellWithScript(IO io, String initScriptFile, Groovysh groovy) {
        if (initScriptFile != null) {
            String line = "";
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(initScriptFile), Charset.forName("UTF-8")));
                while ((line = reader.readLine()) != null) {
                    groovy.execute(line);
                }
                reader.close();
            }
            catch (FileNotFoundException fnfe) {
                io.err.println(String.format("Gremlin initialization file not found at [%s].", initScriptFile));
                System.exit(1);
            }
            catch (IOException ioe) {
                io.err.println(String.format("Bad line in Gremlin initialization file at [%s].", line));
                System.exit(1);
            }
        }
    }
}

