/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import org.cache2k.impl.IntegrityState;
import org.cache2k.impl.LockFreeCache;

public class ClockCache<K, T>
extends LockFreeCache<Entry, K, T> {
    long hits;
    int runCnt;
    int scan24hCnt;
    int scanCnt;
    int size;
    Entry hand;

    @Override
    public long getHitCnt() {
        return this.hits + (long)this.sumUpListHits(this.hand);
    }

    private int sumUpListHits(Entry e) {
        if (e == null) {
            return 0;
        }
        int cnt = 0;
        Entry _head = e;
        do {
            cnt += e.hitCnt;
        } while ((e = (Entry)e.prev) != _head);
        return cnt;
    }

    @Override
    protected void initializeHeapCache() {
        super.initializeHeapCache();
        this.size = 0;
        this.hand = null;
    }

    @Override
    protected void removeEntryFromReplacementList(Entry e) {
        this.hand = ClockCache.removeFromCyclicList(this.hand, e);
        --this.size;
    }

    private int getListSize() {
        return this.size;
    }

    @Override
    protected void recordHit(Entry e) {
        ++e.hitCnt;
    }

    @Override
    protected void insertIntoReplacementList(Entry e) {
        ++this.size;
        this.hand = ClockCache.insertIntoTailCyclicList(this.hand, e);
    }

    @Override
    protected Entry newEntry() {
        return new Entry();
    }

    @Override
    protected Entry findEvictionCandidate() {
        ++this.runCnt;
        int _scanCnt = 0;
        while (this.hand.hitCnt > 0) {
            ++_scanCnt;
            this.hits += (long)this.hand.hitCnt;
            this.hand.hitCnt = 0;
            this.hand = (Entry)this.hand.next;
        }
        if (_scanCnt > this.size) {
            ++this.scan24hCnt;
        }
        this.scanCnt += _scanCnt;
        return this.hand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IntegrityState getIntegrityState() {
        Object object = this.lock;
        synchronized (object) {
            return super.getIntegrityState().checkEquals("getListSize() + evictedButInHashCnt == getSize()", this.getListSize() + this.evictedButInHashCnt, this.getLocalSize()).check("checkCyclicListIntegrity(hand)", ClockCache.checkCyclicListIntegrity(this.hand)).checkEquals("getCyclicListEntryCount(hand) == size", ClockCache.getCyclicListEntryCount(this.hand), this.size);
        }
    }

    @Override
    protected String getExtraStatistics() {
        return ", clockRunCnt=" + this.runCnt + ", scanCnt=" + this.scanCnt + ", scan24hCnt=" + this.scan24hCnt;
    }

    static class Entry<K, T>
    extends org.cache2k.impl.Entry<Entry, K, T> {
        int hitCnt;

        Entry() {
        }
    }
}

