/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl;

import java.util.concurrent.Future;
import org.cache2k.ClosableIterator;
import org.cache2k.impl.BaseCache;
import org.cache2k.impl.Entry;
import org.cache2k.impl.StorageAdapter;
import org.cache2k.impl.threading.Futures;
import org.cache2k.storage.StorageEntry;

public class NoopStorageAdapter
extends StorageAdapter {
    BaseCache cache;

    public NoopStorageAdapter(BaseCache cache) {
        this.cache = cache;
    }

    @Override
    public void open() {
    }

    @Override
    public Future<Void> cancelTimerJobs() {
        return null;
    }

    @Override
    public Future<Void> shutdown() {
        return new Futures.FinishedFuture<Void>();
    }

    @Override
    public void flush() {
    }

    @Override
    public void purge() {
    }

    @Override
    public boolean checkStorageStillDisconnectedForClear() {
        return true;
    }

    @Override
    public void disconnectStorageForClear() {
    }

    @Override
    public Future<Void> clearAndReconnect() {
        return new Futures.FinishedFuture<Object>(null);
    }

    @Override
    public void put(Entry e, long _nextRefreshTime) {
    }

    @Override
    public StorageEntry get(Object key) {
        return null;
    }

    @Override
    public boolean remove(Object key) {
        return false;
    }

    @Override
    public void evict(Entry e) {
    }

    @Override
    public void expire(Entry e) {
    }

    @Override
    public void disable(Throwable t) {
    }

    @Override
    public ClosableIterator<Entry> iterateAll() {
        return new EmptyClosableIterator<Entry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTotalEntryCount() {
        Object object = this.cache.lock;
        synchronized (object) {
            return this.cache.getLocalSize();
        }
    }

    @Override
    public int getAlert() {
        return 0;
    }

    static class EmptyClosableIterator<E>
    implements ClosableIterator<E> {
        EmptyClosableIterator() {
        }

        public void close() {
        }

        public boolean hasNext() {
            return false;
        }

        public E next() {
            return null;
        }

        public void remove() {
        }
    }
}

