/*
 * Decompiled with CFR 0.152.
 */
package org.cache2k.impl.threading;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.cache2k.impl.threading.Futures;
import org.cache2k.impl.threading.GlobalPooledExecutor;
import org.cache2k.impl.util.TunableConstants;

public class LimitedPooledExecutor
implements ExecutorService {
    private static final Tunable TUNABLE = new Tunable();
    private GlobalPooledExecutor globalPooledExecutor;
    private MyNotifier notifier;
    private boolean shutdown = false;
    private Tunable tunable;
    private ExceptionListener exceptionListener;
    static final Object DUMMY_OBJECT = new Object();

    public LimitedPooledExecutor(GlobalPooledExecutor gpe) {
        this(gpe, TUNABLE);
    }

    public LimitedPooledExecutor(GlobalPooledExecutor gpe, Tunable t) {
        this.globalPooledExecutor = gpe;
        this.notifier = new MyNotifier(t.maxThreadCount);
        this.tunable = t;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown && this.notifier.isTerminated();
    }

    @Override
    public boolean awaitTermination(long _timeout, TimeUnit _unit) throws InterruptedException {
        if (!this.shutdown) {
            throw new IllegalStateException("awaitTermination, expects shutdown first");
        }
        this.notifier.waitUntilFinishedComplete(_unit.toMillis(_timeout));
        return this.isTerminated();
    }

    @Override
    public <T> Future<T> submit(Callable<T> c) {
        if (this.notifier.isLimitReached() && !(c instanceof NeverRunInCallingTask)) {
            return this.stallAndRunInCallingThread(c);
        }
        this.notifier.stallAndCountSubmit();
        try {
            Future<T> f = this.globalPooledExecutor.execute(c, (GlobalPooledExecutor.ProgressNotifier)this.notifier);
            return f;
        }
        catch (InterruptedException ex) {
            return new Futures.ExceptionFuture(ex);
        }
        catch (TimeoutException ex) {
            return new Futures.ExceptionFuture(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Future<T> stallAndRunInCallingThread(Callable<T> c) {
        this.notifier.taskSubmittedNoStall();
        this.notifier.taskStarted();
        try {
            T _result = c.call();
            Futures.FinishedFuture<T> finishedFuture = new Futures.FinishedFuture<T>(_result);
            return finishedFuture;
        }
        catch (Exception ex) {
            Futures.ExceptionFuture exceptionFuture = new Futures.ExceptionFuture(ex);
            return exceptionFuture;
        }
        finally {
            this.notifier.taskFinished();
        }
    }

    @Override
    public <T> Future<T> submit(final Runnable r, final T _result) {
        Callable c = new Callable<T>(){

            @Override
            public T call() throws Exception {
                r.run();
                return _result;
            }
        };
        return this.submit(c);
    }

    @Override
    public Future<?> submit(Runnable r) {
        return this.submit(r, DUMMY_OBJECT);
    }

    @Override
    public void execute(Runnable r) {
        this.submit(r);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> _tasks) throws InterruptedException {
        if (!this.tunable.enableUntested) {
            throw new UnsupportedOperationException("untested code");
        }
        ArrayList<Future<T>> _list = new ArrayList<Future<T>>();
        try {
            for (Callable<T> c : _tasks) {
                this.notifier.stallAndCountSubmit();
                Future<T> f = this.globalPooledExecutor.execute(c, (GlobalPooledExecutor.ProgressNotifier)this.notifier);
                _list.add(f);
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        return _list;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> _tasks, long _timeout, TimeUnit _unit) throws InterruptedException {
        if (!this.tunable.enableUntested) {
            throw new UnsupportedOperationException("untested code");
        }
        long now = System.currentTimeMillis();
        long _timeoutMillis = _unit.toMillis(_timeout);
        ArrayList<Future<T>> _list = new ArrayList<Future<T>>();
        try {
            for (Callable<T> c : _tasks) {
                boolean _success;
                long _restTimeout = _timeoutMillis - (System.currentTimeMillis() - now);
                if (_restTimeout > 0L && (_success = this.notifier.stallAndCountSubmit(_restTimeout))) {
                    Future<T> f = this.globalPooledExecutor.execute(c, this.notifier, _restTimeout);
                    _restTimeout = _timeoutMillis - (System.currentTimeMillis() - now);
                    _list.add(f);
                    continue;
                }
                break;
            }
        }
        catch (TimeoutException ex) {
            // empty catch block
        }
        return _list;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    public static class Tunable
    extends TunableConstants {
        public int maxThreadCount = Runtime.getRuntime().availableProcessors() - 1;
        public boolean enableUntested = false;
    }

    public static interface ExceptionListener {
        public void exceptionWasThrown(Throwable var1);
    }

    public static interface NeverRunInCallingTask<V>
    extends Callable<V> {
    }

    class MyNotifier
    implements GlobalPooledExecutor.ProgressNotifier {
        int counter;
        int threadLimit;

        MyNotifier(int _threadLimit) {
            this.threadLimit = _threadLimit;
        }

        public synchronized boolean isTerminated() {
            return this.counter == 0;
        }

        public synchronized void taskSubmittedNoStall() {
            ++this.counter;
        }

        @Override
        public void taskStarted() {
        }

        @Override
        public synchronized void taskFinished() {
            --this.counter;
            this.notify();
        }

        @Override
        public synchronized void taskFinishedWithException(Throwable ex) {
            --this.counter;
            this.notify();
            if (LimitedPooledExecutor.this.exceptionListener != null) {
                LimitedPooledExecutor.this.exceptionListener.exceptionWasThrown(ex);
            }
        }

        public synchronized void waitUntilNextFinished() throws InterruptedException {
            this.wait();
        }

        public synchronized void waitUntilNextFinished(long _millis) throws InterruptedException {
            this.wait(_millis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilFinishedComplete() throws InterruptedException {
            MyNotifier myNotifier = this;
            synchronized (myNotifier) {
                while (this.counter > 0) {
                    this.waitUntilNextFinished();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitUntilFinishedComplete(long _millis) throws InterruptedException {
            long t = System.currentTimeMillis();
            long _maxTime = t + _millis;
            if (_maxTime < 0L) {
                this.waitUntilFinishedComplete();
                return;
            }
            MyNotifier myNotifier = this;
            synchronized (myNotifier) {
                while (this.counter > 0 && t < _maxTime) {
                    long _waitTime = _maxTime - t;
                    if (_waitTime <= 0L) {
                        return;
                    }
                    this.waitUntilNextFinished(_waitTime);
                    t = System.currentTimeMillis();
                }
            }
        }

        public boolean stallAndCountSubmit(long _millis) {
            long t = System.currentTimeMillis();
            long _maxTime = t + _millis;
            if (_maxTime < 0L) {
                this.stallAndCountSubmit();
                return true;
            }
            while (!this.isReady()) {
                if (t >= _maxTime) {
                    return false;
                }
                try {
                    this.waitUntilNextFinished(Math.max(_maxTime - t, 0L));
                    t = System.currentTimeMillis();
                }
                catch (InterruptedException ex) {
                }
            }
            return true;
        }

        private synchronized boolean isReady() {
            if (this.counter < this.threadLimit) {
                ++this.counter;
                return true;
            }
            return false;
        }

        private boolean isLimitReached() {
            return this.counter >= this.threadLimit;
        }

        public void stallAndCountSubmit() {
            while (!this.isReady()) {
                try {
                    this.waitUntilNextFinished();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

